/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.InitializationParameter;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSession;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionStore;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.SerializationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReusedSessionStoreImpl
implements ReusedSessionStore {
    private static final Logger log = Logger.getLogger(ReusedSessionStoreImpl.class.getName());
    private static final long serialVersionUID = 914857799370645455L;
    private static final int SESSION_VALID_IN_SECONDS = 172800;
    private final Map<ByteArray, LinkedList<ByteArray>> rawStore = new LinkedHashMap<ByteArray, LinkedList<ByteArray>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReusedSession pull(InitializationParameter key) {
        Map<ByteArray, LinkedList<ByteArray>> map = this.rawStore;
        synchronized (map) {
            LinkedList<ByteArray> queue = null;
            log.log(Level.FINER, "Pulling key {0} from Session Store", key);
            for (Map.Entry<ByteArray, LinkedList<ByteArray>> entry : this.rawStore.entrySet()) {
                InitializationParameter candidate = entry.getKey().as(InitializationParameter.class);
                if (candidate == null || !candidate.equals(key)) continue;
                queue = entry.getValue();
                break;
            }
            if (queue == null || queue.isEmpty()) {
                return null;
            }
            LinkedList<RawDisposableReusedSession> sessions = this.getValidSessions(queue);
            if (sessions == null || sessions.isEmpty()) {
                return null;
            }
            RawDisposableReusedSession disposableSession = sessions.getLast();
            disposableSession.dispose();
            log.log(Level.FINE, "Reusing session {0} ", disposableSession.getSession().getSessionId());
            return disposableSession.getSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(InitializationParameter key, ReusedSession session) {
        Map<ByteArray, LinkedList<ByteArray>> map = this.rawStore;
        synchronized (map) {
            ByteArray rawSession;
            ByteArray rawKey = ByteArray.fromObject(key);
            if (rawKey == null) {
                log.log(Level.SEVERE, "Unable to store browser initialization parameter in ReusedSessionStore for browser :{0}", key.getDesiredCapabilities().getBrowserName());
                return;
            }
            LinkedList<ByteArray> rawList = this.rawStore.get(rawKey);
            if (rawList == null) {
                rawList = new LinkedList();
                this.rawStore.put(rawKey, rawList);
            }
            if ((rawSession = ByteArray.fromObject(session)) == null) {
                log.log(Level.SEVERE, "Unable to store browser initialization parameter in ReusedSessionStore for browser :{0}", key.getDesiredCapabilities().getBrowserName());
                return;
            }
            TimeStampedSession timeStampedSession = new TimeStampedSession(rawSession);
            rawList.add(ByteArray.fromObject(timeStampedSession));
            log.log(Level.FINE, "Stored session {0} within {1}", new Object[]{timeStampedSession.getSession().getSessionId(), key});
        }
    }

    private LinkedList<RawDisposableReusedSession> getValidSessions(LinkedList<ByteArray> rawQueue) {
        if (rawQueue == null || rawQueue.size() == 0) {
            return new LinkedList<RawDisposableReusedSession>();
        }
        LinkedList<RawDisposableReusedSession> sessions = new LinkedList<RawDisposableReusedSession>();
        Iterator byteArrayIterator = rawQueue.iterator();
        while (byteArrayIterator.hasNext()) {
            TimeStampedSession session = ((ByteArray)byteArrayIterator.next()).as(TimeStampedSession.class);
            ReusedSession reusedSession = session.getSession();
            if (session.isValid(172800) && reusedSession != null) {
                sessions.add(new RawDisposableReusedSession(session.getRawSession(), rawQueue, reusedSession));
                continue;
            }
            if (session.isValid(172800)) continue;
            byteArrayIterator.remove();
        }
        return sessions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RawDisposableReusedSession {
        private final ByteArray key;
        private final ReusedSession session;
        private final LinkedList<ByteArray> parentList;

        public RawDisposableReusedSession(ByteArray key, LinkedList<ByteArray> parentList, ReusedSession session) {
            this.key = key;
            this.parentList = parentList;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            LinkedList<ByteArray> linkedList = this.parentList;
            synchronized (linkedList) {
                Iterator iterator = this.parentList.iterator();
                ReusedSession wrappedKey = this.key.as(ReusedSession.class);
                if (wrappedKey == null) {
                    throw new IllegalStateException("Could not dispose a session from the storage, current session cannot be deserialized.");
                }
                while (iterator.hasNext()) {
                    TimeStampedSession candidate = ((ByteArray)iterator.next()).as(TimeStampedSession.class);
                    if (candidate == null || candidate.getSession() == null || !candidate.getSession().equals(wrappedKey)) continue;
                    iterator.remove();
                }
            }
        }

        public ReusedSession getSession() {
            return this.session;
        }
    }

    static class TimeStampedSession
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Date timestamp = new Date();
        private final ByteArray rawSession;

        public TimeStampedSession(ByteArray rawSession) {
            this.rawSession = rawSession;
        }

        public boolean isValid(int timeoutInSeconds) {
            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.timestamp);
            calendar.add(13, timeoutInSeconds);
            return calendar.getTime().after(now);
        }

        public ReusedSession getSession() {
            return this.rawSession.as(ReusedSession.class);
        }

        public ByteArray getRawSession() {
            return this.rawSession;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rawSession == null ? 0 : this.rawSession.hashCode());
            result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeStampedSession other = (TimeStampedSession)obj;
            if (this.rawSession == null ? other.rawSession != null : !this.rawSession.equals(other.rawSession)) {
                return false;
            }
            return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.timestamp).append(" ").append(this.getSession());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteArray
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] raw = new byte[0];

        ByteArray() {
        }

        static ByteArray fromObject(Serializable object) {
            ByteArray bytes = new ByteArray();
            try {
                bytes.raw = SerializationUtils.serializeToBytes(object);
                return bytes;
            }
            catch (IOException e) {
                log.log(Level.FINE, "Unable to deserialize object of " + object.getClass().getName(), e);
                return null;
            }
        }

        <T extends Serializable> T as(Class<T> classType) {
            try {
                return SerializationUtils.deserializeFromBytes(classType, this.raw);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINE, "Unable to deserialize object of " + classType.getName(), e);
            }
            catch (IOException e) {
                log.log(Level.FINE, "Unable to deserialize object of " + classType.getName(), e);
            }
            catch (ClassCastException e) {
                log.log(Level.FINE, "Unable to deserialize object of " + classType.getName(), e);
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.raw);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ByteArray other = (ByteArray)obj;
            return Arrays.equals(this.raw, other.raw);
        }
    }
}

