/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.common;

import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.extension.byteman.impl.common.ExecContext;
import org.jboss.arquillian.extension.byteman.impl.common.SubmitUtil;

public abstract class AbstractRuleInstaller {
    private static final Logger log = Logger.getLogger(AbstractRuleInstaller.class.getName());
    public static final String CLASS_KEY_PREFIX = "Class:";
    public static final String METHOD_KEY_PREFIX = "Method:";

    protected static void install(String prefix, String script, ExecContext context) {
        if (script != null) {
            try {
                SubmitUtil.install(AbstractRuleInstaller.generateKey(prefix), script, context);
            }
            catch (RuntimeException e) {
                log.severe(String.format("Error installing '%s' script to %s:%s, exec %s, msg: %s", prefix, context.getAddress(), context.getPort(), context.getExec(), e.getMessage()));
                throw e;
            }
        }
    }

    protected static void uninstall(String prefix, String script, ExecContext context) {
        if (script != null) {
            try {
                SubmitUtil.uninstall(AbstractRuleInstaller.generateKey(prefix), script, context);
            }
            catch (RuntimeException e) {
                log.severe(String.format("Error uninstalling '%s' script to  %s:%s, exec %s, msg: %s", prefix, context.getAddress(), context.getPort(), context.getExec(), e.getMessage()));
                throw e;
            }
        }
    }

    protected static boolean isInstalled(String scriptName, ExecContext context) {
        List<String> scriptNames = SubmitUtil.listInstalled(context);
        return scriptNames.contains(AbstractRuleInstaller.generateKey(scriptName));
    }

    private static String generateKey(String prefix) {
        return prefix + Thread.currentThread().getName();
    }
}

