/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.common;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.arquillian.extension.byteman.api.BMRule;

public final class GenerateScriptUtil {
    private GenerateScriptUtil() {
    }

    public static String constructScriptText(BMRule ... bmRules) {
        StringBuilder builder = new StringBuilder();
        builder.append("# BMUnit autogenerated script ");
        for (BMRule bmRule : bmRules) {
            String helper;
            String binding;
            builder.append("\nRULE ");
            builder.append(bmRule.name());
            if (bmRule.isInterface()) {
                builder.append("\nINTERFACE ");
            } else {
                builder.append("\nCLASS ");
            }
            if (bmRule.isOverriding()) {
                builder.append("^");
            }
            builder.append(bmRule.targetClass());
            builder.append("\nMETHOD ");
            builder.append(bmRule.targetMethod());
            String location = bmRule.targetLocation();
            if (location != null && location.length() > 0) {
                builder.append("\nAT ");
                builder.append(location);
            }
            if ((binding = bmRule.binding()) != null && binding.length() > 0) {
                builder.append("\nBIND ");
                builder.append(binding);
            }
            if ((helper = bmRule.helper()) != null && helper.length() > 0) {
                builder.append("\nHELPER ");
                builder.append(helper);
            }
            builder.append("\nIF ");
            builder.append(bmRule.condition());
            builder.append("\nDO ");
            builder.append(bmRule.action());
            builder.append("\nENDRULE\n");
        }
        return builder.toString();
    }

    public static String toString(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        GenerateScriptUtil.copy(input, output);
        return output.toString();
    }

    public static void copy(InputStream input, OutputStream output) {
        try {
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
            output.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read script file", e);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
            try {
                output.close();
            }
            catch (Exception exception) {}
        }
    }
}

