/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.extension.byteman.agent.submit.ScriptText;
import org.jboss.arquillian.extension.byteman.agent.submit.Submit;
import org.jboss.arquillian.extension.byteman.impl.common.ExecContext;
import org.jboss.arquillian.extension.byteman.impl.common.SubmitException;

final class SubmitUtil {
    SubmitUtil() {
    }

    static List<String> listInstalled(ExecContext context) {
        try {
            Submit submit = new Submit(context.getAddress(), context.getPort());
            ArrayList<String> scriptNames = new ArrayList<String>();
            for (ScriptText st : submit.getAllScripts()) {
                scriptNames.add(st.getFileName());
            }
            return scriptNames;
        }
        catch (Exception e) {
            throw new SubmitException("Could not list installed scripts for context " + context, e);
        }
    }

    static void install(String key, String script, ExecContext context) {
        try {
            Submit submit = new Submit(context.getAddress(), context.getPort());
            submit.addScripts(Arrays.asList(new ScriptText(key, script)));
        }
        catch (Exception e) {
            throw new SubmitException("Could not install script '" + script + "' for context " + context, e);
        }
    }

    static void uninstall(String key, String script, ExecContext context) {
        try {
            Submit submit = new Submit(context.getAddress(), context.getPort());
            submit.deleteScripts(Arrays.asList(new ScriptText(key, script)));
        }
        catch (Exception e) {
            throw new SubmitException("Could not uninstall script " + script + " for context " + context, e);
        }
    }
}

