/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.portal.impl.enricher.resource;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.arquillian.container.test.impl.enricher.resource.URLResourceProvider;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.portal.api.PortalURL;
import org.jboss.arquillian.portal.impl.PortletArchiveMetadata;
import org.jboss.arquillian.portal.spi.enricher.resource.PortalURLProvider;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class PortalURLResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<TestClass> testClass;
    @Inject
    Instance<ServiceLoader> loader;
    @Inject
    Instance<PortletArchiveMetadata> portletMetadata;
    private URLResourceProvider urlResourceProvider = new URLResourceProvider();

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        boolean found = false;
        PortalURL portalURL = null;
        for (Annotation annotation : qualifiers) {
            if (!PortalURL.class.isAssignableFrom(annotation.annotationType())) continue;
            portalURL = (PortalURL)PortalURL.class.cast(annotation);
            found = true;
            break;
        }
        if (!found) {
            return this.lookupBaseUrl(resource, qualifiers);
        }
        return this.locateURL(resource, qualifiers, portalURL);
    }

    protected Object lookupBaseUrl(ArquillianResource resource, Annotation ... qualifiers) {
        this.injector().inject((Object)this.urlResourceProvider);
        return this.urlResourceProvider.lookup(resource, qualifiers);
    }

    protected Injector injector() {
        return (Injector)this.injector.get();
    }

    private Object locateURL(ArquillianResource resource, Annotation[] qualifiers, PortalURL portalURL) {
        return this.toURL((URL)this.lookupBaseUrl(resource, qualifiers), portalURL);
    }

    private URL toURL(URL original, PortalURL portalURL) {
        Collection providers = ((ServiceLoader)this.loader.get()).all(PortalURLProvider.class);
        String[] portlets = this.getPortletList(portalURL);
        Iterator i$ = providers.iterator();
        if (i$.hasNext()) {
            PortalURLProvider provider = (PortalURLProvider)i$.next();
            try {
                return provider.customizeURL(original, portlets);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create portal specific url based on " + original + " from provider: " + provider, e);
            }
        }
        return original;
    }

    private String[] getPortletList(PortalURL portalURL) {
        String[] portlets = portalURL.value();
        if (portlets.length > 0 && portlets[0].length() > 0) {
            return portlets;
        }
        portlets = ((PortletArchiveMetadata)this.portletMetadata.get()).getPortletNames().toArray(portlets);
        return portlets;
    }
}

