/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.portal.impl.gatein.deployment;

import java.io.File;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.portal.api.PortalTest;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webfragment30.WebFragmentDescriptor;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

public class GateInDeploymentEnricher
implements ApplicationArchiveProcessor {
    public static final String EMBED_PATH = "embed";
    private static final String EMBED_SERVLET_NAME = "EmbedServlet";
    private static final String EMBED_SERVLET_CLASS = "org.gatein.pc.embed.EmbedServlet";
    private static final ArchivePath WEB_XML_PATH = ArchivePaths.create((String)"WEB-INF/web.xml");

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        if (testClass.isAnnotationPresent(PortalTest.class) && applicationArchive instanceof WebArchive) {
            WebArchive webArchive = (WebArchive)applicationArchive;
            File[] files = (File[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.gatein.pc:pc-embed")).withTransitivity()).as(File.class);
            webArchive.addAsLibraries(files);
            files = (File[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("javax.portlet:portlet-api")).withoutTransitivity()).as(File.class);
            webArchive.addAsLibraries(files);
            this.addEmbed(webArchive);
        }
    }

    private void addEmbed(WebArchive webArchive) {
        Node webXmlNode = webArchive.get(WEB_XML_PATH);
        if (null != webXmlNode) {
            WebAppDescriptor webXml = (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).fromStream(webXmlNode.getAsset().openStream());
            webArchive.delete(WEB_XML_PATH);
            webArchive.setWebXML((Asset)new StringAsset(this.addEmbedToDescriptor(webXml).exportAsString()));
        } else {
            WebFragmentDescriptor webFrag = (WebFragmentDescriptor)Descriptors.create(WebFragmentDescriptor.class);
            JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            jar.addAsManifestResource((Asset)new StringAsset(this.addEmbedToFragment(webFrag).exportAsString()), "web-fragment.xml");
            webArchive.addAsLibrary((Archive)jar);
        }
    }

    private WebFragmentDescriptor addEmbedToFragment(WebFragmentDescriptor webFragment) {
        ((WebFragmentDescriptor)webFragment.createServlet().servletName(EMBED_SERVLET_NAME).servletClass(EMBED_SERVLET_CLASS).loadOnStartup(Integer.valueOf(0)).up()).createServletMapping().servletName(EMBED_SERVLET_NAME).urlPattern(new String[]{"/embed/*"}).up();
        return webFragment;
    }

    private WebAppDescriptor addEmbedToDescriptor(WebAppDescriptor webXml) {
        ((WebAppDescriptor)webXml.createServlet().servletName(EMBED_SERVLET_NAME).servletClass(EMBED_SERVLET_CLASS).loadOnStartup(Integer.valueOf(0)).up()).createServletMapping().servletName(EMBED_SERVLET_NAME).urlPattern(new String[]{"/embed/*"}).up();
        return webXml;
    }
}

