/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.client.execution;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.warp.client.execution.RequestEnrichment;
import org.jboss.arquillian.warp.client.execution.ResponseEnrichment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AssertionHolder {
    private static final long WAIT_TIMEOUT_MILISECONDS = 30000L;
    private static final long THREAD_SLEEP = 50L;
    private static final long NUMBER_OF_WAIT_LOOPS = 600L;
    private static final AtomicBoolean enrichmentAdvertised = new AtomicBoolean(false);
    private static final AtomicBoolean enrichmentFinished = new AtomicBoolean(false);
    private static final Set<RequestEnrichment> requests = new CopyOnWriteArraySet<RequestEnrichment>();
    private static final Set<ResponseEnrichment> responses = new CopyOnWriteArraySet<ResponseEnrichment>();
    private static CountDownLatch responsesLatch;

    AssertionHolder() {
    }

    public static void advertise() {
        enrichmentAdvertised.set(true);
    }

    public static void setExpectedRequests(int requests) {
        responsesLatch = new CountDownLatch(requests);
    }

    public static void finished() {
        enrichmentFinished.set(true);
    }

    private static boolean isEnrichmentAdvertised() {
        return enrichmentAdvertised.get();
    }

    private static boolean isEnrichmentFinished() {
        return enrichmentFinished.get();
    }

    static boolean isWaitingForRequests() {
        return AssertionHolder.isEnrichmentAdvertised();
    }

    private static boolean isWaitingForEnriching() {
        return AssertionHolder.isEnrichmentAdvertised() && !AssertionHolder.isEnrichmentFinished();
    }

    static boolean isWaitingForResponses() {
        return responsesLatch.getCount() > 0L;
    }

    public static void addRequest(RequestEnrichment request) {
        Validate.notNull((Object)request, (String)"enrichment can't be null");
        requests.add(request);
    }

    static Set<RequestEnrichment> getRequests() {
        AssertionHolder.awaitRequests();
        return Collections.unmodifiableSet(requests);
    }

    static void addResponse(ResponseEnrichment response) {
        Validate.notNull((Object)response, (String)"response can't be null");
        responses.add(response);
        responsesLatch.countDown();
    }

    static void finishEnrichmentRound() {
        responsesLatch = null;
        enrichmentAdvertised.set(false);
        enrichmentFinished.set(false);
        requests.clear();
        responses.clear();
    }

    public static Set<ResponseEnrichment> getResponses() {
        AssertionHolder.awaitResponses();
        return Collections.unmodifiableSet(responses);
    }

    private static void awaitRequests() {
        if (!AssertionHolder.isWaitingForEnriching()) {
            return;
        }
        int i = 0;
        while ((long)i < 600L) {
            try {
                Thread.sleep(50L);
                if (!AssertionHolder.isEnrichmentAdvertised()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            ++i;
        }
        throw new SettingRequestTimeoutException();
    }

    private static void awaitResponses() {
        try {
            boolean finishedNicely = responsesLatch.await(30000L, TimeUnit.MILLISECONDS);
            if (!finishedNicely) {
                throw new ServerResponseTimeoutException();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class RequestEnrichmentAlreadySetException
    extends RuntimeException {
        private static final long serialVersionUID = 8333157142743791135L;
    }

    public static class ServerResponseTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = 7267806785171391801L;
    }

    public static class SettingRequestTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -6743564150233628034L;
    }
}

