/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.client.execution;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.jboss.arquillian.warp.HttpRequest;
import org.jboss.arquillian.warp.RequestFilter;
import org.jboss.arquillian.warp.client.execution.AssertionHolder;
import org.jboss.arquillian.warp.client.execution.RequestEnrichment;
import org.jboss.arquillian.warp.client.execution.ResponseEnrichment;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.shared.RequestPayload;
import org.jboss.arquillian.warp.shared.ResponsePayload;
import org.jboss.arquillian.warp.utils.SerializationUtils;
import org.littleshoot.proxy.HttpRequestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestEnrichmentFilter
implements HttpRequestFilter {
    public void filter(org.jboss.netty.handler.codec.http.HttpRequest request) {
        if (AssertionHolder.isWaitingForRequests()) {
            try {
                Collection<RequestPayload> payloads = this.getMatchingPayloads(request);
                if (!payloads.isEmpty()) {
                    RequestPayload assertion = payloads.iterator().next();
                    String requestEnrichment = SerializationUtils.serializeToBase64(assertion);
                    request.setHeader("X-Arq-Enrichment-Request", Arrays.asList(requestEnrichment));
                }
            }
            catch (Exception originalException) {
                ClientWarpExecutionException wrappedException = new ClientWarpExecutionException("enriching request failed: " + originalException.getMessage(), (Throwable)originalException);
                ResponsePayload exceptionPayload = new ResponsePayload((Throwable)wrappedException);
                ResponseEnrichment responseEnrichment = new ResponseEnrichment(exceptionPayload);
                AssertionHolder.addResponse(responseEnrichment);
            }
        }
    }

    private Collection<RequestPayload> getMatchingPayloads(org.jboss.netty.handler.codec.http.HttpRequest request) {
        Set<RequestEnrichment> requests = AssertionHolder.getRequests();
        HttpRequestWrapper httpRequest = new HttpRequestWrapper(request);
        LinkedList<RequestPayload> payloads = new LinkedList<RequestPayload>();
        for (RequestEnrichment enrichment : requests) {
            RequestFilter<?> httpRequestFilter;
            RequestFilter<?> filter = enrichment.getFilter();
            if (filter == null) {
                payloads.add(enrichment.getPayload());
                continue;
            }
            if (!this.isType(filter, (Type)((Object)HttpRequest.class)) || !(httpRequestFilter = filter).matches((Object)httpRequest)) continue;
            payloads.add(enrichment.getPayload());
        }
        return payloads;
    }

    private boolean isType(RequestFilter<?> filter, Type expectedType) {
        Type[] interfaces;
        for (Type type : interfaces = filter.getClass().getGenericInterfaces()) {
            ParameterizedType parametrizedType;
            if (!(type instanceof ParameterizedType) || (parametrizedType = (ParameterizedType)type).getRawType() != RequestFilter.class) continue;
            return parametrizedType.getActualTypeArguments()[0] == expectedType;
        }
        return false;
    }

    private class HttpRequestWrapper
    implements HttpRequest {
        private org.jboss.netty.handler.codec.http.HttpRequest request;

        public HttpRequestWrapper(org.jboss.netty.handler.codec.http.HttpRequest request) {
            this.request = request;
        }

        public String getMethod() {
            return this.request.getMethod().getName();
        }

        public String getUri() {
            return this.request.getUri();
        }
    }
}

