/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.client.proxy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.warp.utils.URLUtils;

public class URLMapping {
    private static final int BASE = 18080;
    private int sequenceNumber = 0;
    private Map<URL, URL> map = new HashMap<URL, URL>();

    public synchronized URL getProxyURL(URL url) {
        URL base = URLUtils.getUrlBase(url);
        if (this.map.containsKey(base)) {
            return this.map.get(base);
        }
        int proxyPort = this.generatePort();
        URL proxyUrl = this.newProxyUrlWithPort(base, proxyPort);
        this.map.put(base, proxyUrl);
        return proxyUrl;
    }

    public int generatePort() {
        return this.newPort();
    }

    private int newPort() {
        return 18080 + this.sequenceNumber++;
    }

    private URL newProxyUrlWithPort(URL url, int port) {
        try {
            return new URL(url.getProtocol(), "localhost", port, url.getFile());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

