/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.server.test;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.warp.server.test.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleTestDeenricher {
    private Map<Field, Object> backupAll = new HashMap<Field, Object>();
    private Map<Field, Object> backupUpdated = new HashMap<Field, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTest(@Observes(precedence=100) EventContext<Before> context) {
        Object testInstance = ((Before)context.getEvent()).getTestInstance();
        this.backupAllFields(testInstance);
        try {
            context.proceed();
        }
        finally {
            this.backupUpdatedFields(testInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTest(@Observes(precedence=100) EventContext<After> context) {
        Object testInstance = ((After)context.getEvent()).getTestInstance();
        try {
            context.proceed();
        }
        finally {
            this.restoreFields(testInstance);
        }
    }

    private void backupAllFields(Object instance) {
        try {
            List<Field> fields = SecurityActions.getFields(instance.getClass());
            for (Field field : fields) {
                this.backupAll.put(field, field.get(instance));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void backupUpdatedFields(Object instance) {
        try {
            for (Map.Entry<Field, Object> entry : this.backupAll.entrySet()) {
                Object newValue;
                Object oldValue;
                Field field = entry.getKey();
                if (!this.hasChanged(field, oldValue = entry.getValue(), newValue = field.get(instance))) continue;
                this.backupUpdated.put(field, oldValue);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.backupAll.clear();
    }

    private boolean hasChanged(Field field, Object oldValue, Object newValue) {
        if (field.getType().isPrimitive()) {
            return !oldValue.equals(newValue);
        }
        return oldValue != newValue;
    }

    private void restoreFields(Object instance) {
        try {
            for (Map.Entry<Field, Object> entry : this.backupUpdated.entrySet()) {
                Field field = entry.getKey();
                Object oldValue = entry.getValue();
                if (!this.validateIfFieldCanBeSetAndSerialized(field)) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(instance, oldValue);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.backupUpdated.clear();
    }

    private boolean validateIfFieldCanBeSetAndSerialized(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()));
    }
}

