/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.server.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.Test;
import org.jboss.arquillian.warp.server.assertion.AssertionRegistry;
import org.jboss.arquillian.warp.server.test.SecurityActions;
import org.jboss.arquillian.warp.spi.LifecycleEvent;

public class LifecycleTestDriver {
    @Inject
    private Instance<AssertionRegistry> registry;
    @Inject
    private Event<Before> before;
    @Inject
    private Event<After> after;
    @Inject
    private Event<Test> test;

    public void fireTest(@Observes LifecycleEvent event) {
        AssertionRegistry registry = this.getRegistry();
        for (Object assertionObject : registry.getAssertions()) {
            Annotation annotation = event.getAnnotation();
            List<Method> methods = SecurityActions.getMethodsWithAnnotation(assertionObject.getClass(), annotation);
            for (Method testMethod : methods) {
                this.before.fire((Object)new Before(assertionObject, testMethod));
                this.test.fire((Object)new Test((TestMethodExecutor)new LifecycleMethodExecutor(assertionObject, testMethod)));
                this.after.fire((Object)new After(assertionObject, testMethod));
            }
        }
    }

    private AssertionRegistry getRegistry() {
        return (AssertionRegistry)this.registry.get();
    }

    private static class LifecycleMethodExecutor
    implements TestMethodExecutor {
        private Object instance;
        private Method method;

        public LifecycleMethodExecutor(Object instance, Method method) {
            this.instance = instance;
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void invoke(Object ... parameters) throws Throwable {
            this.method.invoke(this.instance, parameters);
        }
    }
}

