/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.server.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static Constructor<?> getConstructor(final Class<?> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws NoSuchMethodException {
                    return clazz.getConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Object obj;
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
            Class<?> implClass = Class.forName(className, false, tccl);
            Constructor<?> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + className + ", missing package from classpath?", e);
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Incorrect expected type, " + expectedType.getName() + ", defined for " + obj.getClass().getName());
        }
    }

    static boolean isClassPresent(String name) {
        try {
            ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static List<Field> getFieldsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        List<Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Field field : nextSource.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(annotationClass)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        foundFields.add(field);
                    }
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }

    static List<Method> getMethodsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        List<Method> declaredAccessableMethods = AccessController.doPrivileged(new PrivilegedAction<List<Method>>(){

            @Override
            public List<Method> run() {
                ArrayList<Method> foundMethods = new ArrayList<Method>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Method method : nextSource.getDeclaredMethods()) {
                        if (!method.isAnnotationPresent(annotationClass)) continue;
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        foundMethods.add(method);
                    }
                }
                return foundMethods;
            }
        });
        return declaredAccessableMethods;
    }

    static List<Method> getMethodsWithAnnotation(Class<?> source, Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        List<Method> declaredAccessableMethods = SecurityActions.getMethodsWithAnnotation(source, annotationType);
        HashSet<Method> result = new HashSet<Method>(declaredAccessableMethods);
        for (Method method : declaredAccessableMethods) {
            Annotation methodAnnotation = method.getAnnotation(annotationType);
            for (Method parameter : annotationType.getMethods()) {
                Object referenceValue;
                Object annotationValue;
                if (parameter.getDeclaringClass() != annotationType || (annotationValue = SecurityActions.invokeSafely(methodAnnotation, parameter, new Object[0])).equals(referenceValue = SecurityActions.invokeSafely(annotation, parameter, new Object[0]))) continue;
                result.remove(method);
            }
        }
        return new LinkedList<Method>(result);
    }

    private static Method getMethodSafely(Class<?> clazz, String methodName, Class<?> ... params) {
        try {
            return clazz.getMethod(methodName, params);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object invokeSafely(Object instance, Method method, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static List<Field> getFields(final Class<?> source) {
        List<Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Field field : nextSource.getDeclaredFields()) {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        foundFields.add(field);
                    }
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }

    static boolean isAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> needle) {
        for (Annotation a : annotations) {
            if (a.annotationType() != needle) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

