/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.AbstractGrapheneEnricherTest;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;

public class TestWebElementEnricher
extends AbstractGrapheneEnricherTest {
    @Mock
    WebDriver driver;
    @Mock
    WebElement element;

    @Test
    public void testEmptyFindBy() {
        this.thrown.expect(GrapheneTestEnricherException.class);
        this.getGrapheneEnricher().enrich((Object)new EmptyFindByTest());
    }

    @Test
    public void generated_webelement_implements_WrapsElement_interface() {
        TestPage page = new TestPage();
        this.getGrapheneEnricher().enrich((Object)page);
        Assert.assertTrue((boolean)(page.element instanceof WrapsElement));
        GrapheneContext.set((WebDriver)this.driver);
        Mockito.when((Object)this.driver.findElement((By)Mockito.any(By.class))).thenReturn((Object)this.element);
        WebElement wrappedElement = ((WrapsElement)page.element).getWrappedElement();
        GrapheneContext.reset();
        Assert.assertEquals((Object)this.element, (Object)wrappedElement);
    }

    public static class TestPage {
        @FindBy(id="id")
        private WebElement element;
    }

    public static class EmptyFindByTest {
        @FindBy
        private WebElement wrongWebElem;
    }
}

