/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.AbstractGrapheneEnricherTest;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class TestWebElementLazyEvaluation
extends AbstractGrapheneEnricherTest {
    @Test
    public void when_WebElement_is_injected_then_it_is_first_evaluated_at_first_interaction() {
        WebDriver driver = (WebDriver)Mockito.mock(WebDriver.class);
        WebElement element = (WebElement)Mockito.mock(WebElement.class);
        Mockito.when((Object)driver.findElement((By)Matchers.any(By.class))).thenReturn((Object)element);
        GrapheneContext.set((WebDriver)driver);
        TPageFragment fragment = new TPageFragment();
        this.getGrapheneEnricher().enrich((Object)fragment);
        Mockito.verifyZeroInteractions((Object[])new Object[]{driver, element});
        fragment.element.click();
        fragment.element.click();
        ((WebDriver)Mockito.verify((Object)driver, (VerificationMode)Mockito.times((int)2))).findElement((By)Matchers.any(By.class));
        ((WebElement)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)2))).click();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{driver, element});
    }

    @Test
    public void when_page_fragment_is_injected_then_searching_for_its_siblings_is_done_for_each_invocation() {
        WebDriver driver = (WebDriver)Mockito.mock(WebDriver.class);
        WebElement rootElement = (WebElement)Mockito.mock(WebElement.class);
        WebElement element = (WebElement)Mockito.mock(WebElement.class);
        Mockito.when((Object)driver.findElement((By)Matchers.any(By.class))).thenReturn((Object)rootElement);
        Mockito.when((Object)rootElement.findElement((By)Matchers.any(By.class))).thenReturn((Object)element);
        GrapheneContext.set((WebDriver)driver);
        TPage page = new TPage();
        this.getGrapheneEnricher().enrich((Object)page);
        Mockito.verifyZeroInteractions((Object[])new Object[]{driver, element});
        page.fragment.element.click();
        page.fragment.element.click();
        page.fragment.element.click();
        ((WebDriver)Mockito.verify((Object)driver, (VerificationMode)Mockito.times((int)3))).findElement((By)Matchers.any(By.class));
        ((WebElement)Mockito.verify((Object)rootElement, (VerificationMode)Mockito.times((int)3))).findElement((By)Matchers.any(By.class));
        ((WebElement)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)3))).click();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{driver, element});
    }

    private static class TPageFragment {
        @FindBy(id="test")
        WebElement element;

        private TPageFragment() {
        }
    }

    private static class TPage {
        @FindBy(id="test")
        TPageFragment fragment;

        private TPage() {
        }
    }
}

