/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;

public class GrapheneConfigurationContext {
    private static final ThreadLocal<GrapheneConfiguration> REFERENCE = new ThreadLocal();
    private static GrapheneProxy.FutureTarget TARGET = new GrapheneProxy.FutureTarget(){

        public Object getTarget() {
            return GrapheneConfigurationContext.get();
        }
    };

    static GrapheneConfiguration get() {
        GrapheneConfiguration configuration = REFERENCE.get();
        if (configuration == null) {
            throw new NullPointerException("configuration is null - it needs to be setup before starting to use it");
        }
        return configuration;
    }

    public static GrapheneConfiguration getProxy() {
        return (GrapheneConfiguration)GrapheneProxy.getProxyForFutureTarget(TARGET, GrapheneConfiguration.class, new Class[0]);
    }

    public static boolean isInitialized() {
        return REFERENCE.get() != null;
    }

    public static void reset() {
        REFERENCE.set(null);
    }

    public static void set(GrapheneConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration instance can't be null");
        }
        if (GrapheneProxy.isProxyInstance(configuration)) {
            throw new IllegalArgumentException("instance of the proxy can't be set to the configuration");
        }
        REFERENCE.set(configuration);
    }
}

