/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.util.List;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.WebElementUtils;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.jboss.arquillian.graphene.enricher.findby.FindByUtilities;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class WebElementEnricher
extends AbstractSearchContextEnricher {
    public void enrich(SearchContext searchContext, Object target) {
        try {
            List<Field> fields = FindByUtilities.getListOfFieldsAnnotatedWithFindBys(target);
            for (Field field : fields) {
                By by = FindByUtilities.getCorrectBy(field);
                String message = "Your @FindBy annotation over field " + NEW_LINE + field.getClass() + NEW_LINE + " declared in: " + NEW_LINE + field.getDeclaringClass().getName() + NEW_LINE + " is annotated with empty @FindBy annotation, in other words it " + "should contain parameter which will define the strategy for referencing that element.";
                if (field.getType().isAssignableFrom(WebElement.class)) {
                    if (by == null) {
                        throw new GrapheneTestEnricherException(message);
                    }
                    WebElement element = WebElementUtils.findElementLazily(by, searchContext);
                    WebElementEnricher.setValue(field, target, element);
                    continue;
                }
                if (!field.getType().isAssignableFrom(List.class) || !this.getListType(field).isAssignableFrom(WebElement.class)) continue;
                if (by == null) {
                    throw new GrapheneTestEnricherException(message);
                }
                List<WebElement> elements = WebElementUtils.findElementsLazily(by, searchContext);
                WebElementEnricher.setValue(field, target, elements);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

