/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.graphene.enricher.StaleElementInterceptor;
import org.jboss.arquillian.graphene.enricher.WrapsElementInterceptor;
import org.jboss.arquillian.graphene.intercept.InterceptorBuilder;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebElementUtils {
    private WebElementUtils() {
    }

    public static WebElement findElement(final By by, final SearchContext searchContext) {
        final WebElement firstFound = searchContext.findElement(by);
        return WebElementUtils.findElement(new GrapheneProxy.FutureTarget(){
            private WebElement element;
            {
                this.element = firstFound;
            }

            public Object getTarget() {
                if (this.element == null) {
                    if (searchContext instanceof GrapheneProxyInstance) {
                        return ((SearchContext)((GrapheneProxyInstance)searchContext).unwrap()).findElement(by);
                    }
                    return searchContext.findElement(by);
                }
                WebElement toReturn = this.element;
                this.element = null;
                return toReturn;
            }
        });
    }

    public static WebElement findElementLazily(final By by, final SearchContext searchContext, final int indexInList) {
        return WebElementUtils.findElement(new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                return searchContext.findElements(by).get(indexInList);
            }
        });
    }

    public static WebElement findElementLazily(final By by, final SearchContext searchContext) {
        return WebElementUtils.findElement(new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                return searchContext.findElement(by);
            }
        });
    }

    public static List<WebElement> findElementsLazily(final By by, final SearchContext searchContext) {
        return (List)GrapheneProxy.getProxyForFutureTarget(new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                ArrayList<WebElement> result = new ArrayList<WebElement>();
                List elements = searchContext.findElements(by);
                for (int i = 0; i < elements.size(); ++i) {
                    result.add(WebElementUtils.findElementLazily(by, searchContext, i));
                }
                return result;
            }
        }, List.class, new Class[0]);
    }

    protected static WebElement findElement(GrapheneProxy.FutureTarget target) {
        WebElement element = (WebElement)GrapheneProxy.getProxyForFutureTarget(target, WebElement.class, Locatable.class, WrapsElement.class);
        GrapheneProxyInstance elementProxy = (GrapheneProxyInstance)element;
        InterceptorBuilder b = new InterceptorBuilder();
        b.interceptInvocation(WrapsElement.class, new WrapsElementInterceptor(elementProxy)).getWrappedElement();
        elementProxy.registerInterceptor(b.build());
        elementProxy.registerInterceptor(new StaleElementInterceptor());
        return element;
    }
}

