/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.Method;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;

public class InvocationContextImpl
implements InvocationContext {
    private final InvocationContext following;
    private final Interceptor interceptor;
    private final Object target;
    private final Method method;
    private final Object[] arguments;

    public InvocationContextImpl(Object target, Method method, Object[] arguments) {
        if (target == null) {
            throw new IllegalArgumentException("The parameter [target] is null.");
        }
        if (method == null) {
            throw new IllegalArgumentException("The parameter [method] is null.");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("The parameter [arguments] is null.");
        }
        this.following = null;
        this.interceptor = null;
        this.arguments = arguments;
        this.method = method;
        this.target = target;
    }

    public InvocationContextImpl(Interceptor interceptor, InvocationContext following) {
        if (following == null) {
            throw new IllegalArgumentException("The parameter [following] is null.");
        }
        if (interceptor == null) {
            throw new IllegalArgumentException("The parameter [interceptor] is null.");
        }
        this.following = following;
        this.interceptor = interceptor;
        this.arguments = null;
        this.method = null;
        this.target = null;
    }

    public Object invoke() throws Throwable {
        if (this.following == null) {
            return this.method.invoke(this.target, this.arguments);
        }
        return this.interceptor.intercept(this.following);
    }

    public Method getMethod() {
        return this.method == null ? this.following.getMethod() : this.method;
    }

    public Object[] getArguments() {
        return this.arguments == null ? this.following.getArguments() : this.arguments;
    }

    public Object getTarget() {
        return this.target == null ? this.following.getTarget() : this.target;
    }
}

