/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl.enricher.resource;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.impl.enricher.resource.SecurityActions;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArquillianResourceTestEnricher
implements TestEnricher {
    @Inject
    private Instance<ServiceLoader> loader;

    public void enrich(Object testCase) {
        System.out.println("Enriching test case: " + testCase.getClass().getName());
        for (Field field : SecurityActions.getFieldsWithAnnotation(testCase.getClass(), ArquillianResource.class)) {
            System.out.println("Enriching field: " + field.getName());
            Object value = null;
            try {
                List<Annotation> qualifiers = this.filterAnnotations(Arrays.asList(field.getAnnotations()));
                this.checkPresentScopeInjection(qualifiers, ResourceProvider.ClassInjection.class);
                this.checkPresentScopeInjection(qualifiers, ResourceProvider.MethodInjection.class);
                SerializableClassInjection classInjectedResource = new SerializableClassInjection();
                qualifiers.add((Annotation)((Object)classInjectedResource));
                System.out.println("Looking up field value to adding to field");
                value = this.lookup(field.getType(), field.getAnnotation(ArquillianResource.class), qualifiers);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not lookup value for field " + field, e);
            }
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(testCase, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set value on field " + field + " using " + value);
            }
        }
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ArquillianResource resource = this.getResourceAnnotation(method.getParameterAnnotations()[i]);
            if (resource == null) continue;
            List<Annotation> qualifiers = this.filterAnnotations(Arrays.asList(method.getParameterAnnotations()[i]));
            this.checkPresentScopeInjection(qualifiers, ResourceProvider.ClassInjection.class);
            this.checkPresentScopeInjection(qualifiers, ResourceProvider.MethodInjection.class);
            SerializableMethodInjection methodInjectedResource = new SerializableMethodInjection();
            qualifiers.add((Annotation)((Object)methodInjectedResource));
            values[i] = this.lookup(method.getParameterTypes()[i], resource, qualifiers);
        }
        return values;
    }

    private Object lookup(Class<?> type, ArquillianResource resource, List<Annotation> qualifiers) {
        Collection resourceProviders = ((ServiceLoader)this.loader.get()).all(ResourceProvider.class);
        System.out.println("Available resource providers:");
        for (ResourceProvider resourceProvider : resourceProviders) {
            System.out.println("provider = " + resourceProvider.getClass().getName() + ", provides for type = " + (resourceProvider.canProvide(type) ? "true" : "false"));
        }
        for (ResourceProvider resourceProvider : resourceProviders) {
            System.out.println("Checking resource provider: " + resourceProvider.getClass().getName());
            if (!resourceProvider.canProvide(type)) continue;
            Object value = resourceProvider.lookup(resource, qualifiers.toArray(new Annotation[0]));
            if (value == null) {
                throw new RuntimeException("Provider for type " + type + " returned a null value: " + resourceProvider);
            }
            System.out.println("Selected resource provider: " + resourceProvider.getClass().getName());
            return value;
        }
        throw new IllegalArgumentException("No ResourceProvider found for type: " + type);
    }

    private ArquillianResource getResourceAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != ArquillianResource.class) continue;
            return (ArquillianResource)annotation;
        }
        return null;
    }

    private List<Annotation> filterAnnotations(List<Annotation> annotations) {
        ArrayList<Annotation> filtered = new ArrayList<Annotation>();
        if (annotations == null) {
            return filtered;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() == ArquillianResource.class) continue;
            filtered.add(annotation);
        }
        return filtered;
    }

    private void checkPresentScopeInjection(List<Annotation> qualifiers, Class<? extends Annotation> scope) {
        boolean present = false;
        for (Annotation qualifier : qualifiers) {
            if (!scope.isAssignableFrom(qualifier.annotationType())) continue;
            present = true;
            break;
        }
        if (present) {
            throw new IllegalStateException(String.format("You have put %s or its subclass on ArquillianResource injection point with qualifiers '%s'. This annotation is not supposed to be used in your test case.", scope.getName(), qualifiers.toString()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializableMethodInjection
    implements ResourceProvider.MethodInjection,
    Serializable {
        private static final long serialVersionUID = 1L;

        public Class<? extends Annotation> annotationType() {
            return ResourceProvider.MethodInjection.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializableClassInjection
    implements ResourceProvider.ClassInjection,
    Serializable {
        private static final long serialVersionUID = 1L;

        public Class<? extends Annotation> annotationType() {
            return ResourceProvider.ClassInjection.class;
        }
    }
}

