/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.test.spi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClass {
    private TestClass parent;
    private Class<?> testClass;
    private Set<TestClass> children;

    public TestClass(Class<?> testClass) {
        this(null, testClass);
    }

    public TestClass(TestClass parent, Class<?> testClass) {
        if (testClass == null) {
            throw new IllegalArgumentException("Null testClass");
        }
        this.children = new HashSet<TestClass>();
        this.parent = parent;
        this.testClass = testClass;
        if (parent != null) {
            this.parent.addChild(this);
        }
    }

    public Class<?> getJavaClass() {
        return this.testClass;
    }

    public String getName() {
        return this.testClass.getName();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.testClass.isAnnotationPresent(annotation);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.testClass.getAnnotation(annotation);
    }

    public Method getMethod(Class<? extends Annotation> annotation) {
        Method[] methods = this.getMethods(annotation);
        if (methods.length > 0) {
            return methods[0];
        }
        return null;
    }

    public Method[] getMethods(Class<? extends Annotation> annotation) {
        return SecurityActions.getMethodsWithAnnotation(this.testClass, annotation).toArray(new Method[0]);
    }

    void addChild(TestClass child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public TestClass getParent() {
        return this.parent;
    }

    public List<Class<?>> getChildrenChain() {
        ArrayList childrenChain = new ArrayList();
        childrenChain.add(this.getJavaClass());
        for (TestClass child : this.children) {
            childrenChain.addAll(child.getChildrenChain());
        }
        return childrenChain;
    }

    public List<TestClass> getParentChain() {
        ArrayList<TestClass> all = new ArrayList<TestClass>();
        if (this.isSuite()) {
            all.add(this);
        }
        TestClass parent = this;
        while ((parent = parent.getParent()) != null) {
            all.add(parent);
        }
        return all;
    }

    public boolean isSuite() {
        return this.children.size() > 0;
    }
}

