/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class BundleContextProvider
implements ResourceProvider {
    private AtomicBoolean initialized = new AtomicBoolean();
    @Inject
    @ApplicationScoped
    private InstanceProducer<BundleContext> bundleContextProducer;
    @Inject
    private Instance<BundleContext> bundleContext;

    public boolean canProvide(Class<?> type) {
        return type.isAssignableFrom(BundleContext.class);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        this.initialize();
        return this.bundleContext.get();
    }

    private void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            this.bundleContextProducer.set((Object)BundleContextProvider.getBundleContext());
        }
    }

    static BundleContext getBundleContext() {
        ClassLoader classLoader;
        BundleContext bundleContext = BundleContextAssociation.getBundleContext();
        if (bundleContext == null && (classLoader = BundleContextProvider.class.getClassLoader()) instanceof BundleReference) {
            BundleReference bref = (BundleReference)classLoader;
            bundleContext = bref.getBundle().getBundleContext();
            bundleContext = bundleContext.getBundle(0L).getBundleContext();
        }
        return bundleContext;
    }
}

