/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.handlers.SecurityActions;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;

public abstract class CommandHandlerWithHelp
implements CommandHandler {
    private final String filename;
    private final boolean connectionRequired;
    private CommandLineCompleter argsCompleter;
    protected final ArgumentWithoutValue helpArg = new ArgumentWithoutValue(new String[]{"--help", "-h"}){

        @Override
        public boolean canAppearNext(CommandContext ctx) {
            return !ctx.getParsedArguments().hasArguments();
        }
    };

    public CommandHandlerWithHelp(String command) {
        this(command, false);
    }

    public CommandHandlerWithHelp(String command, boolean connectionRequired) {
        if (command == null) {
            throw new IllegalArgumentException("command can't be null");
        }
        this.filename = "help/" + command + ".txt";
        this.connectionRequired = connectionRequired;
        SimpleArgumentTabCompleter argsCompleter = new SimpleArgumentTabCompleter();
        argsCompleter.addArgument(this.helpArg);
        this.argsCompleter = argsCompleter;
    }

    public void setArgumentCompleter(CommandLineCompleter argsCompleter) {
        this.argsCompleter = argsCompleter;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return !this.connectionRequired || ctx.getModelControllerClient() != null;
    }

    @Override
    public CommandLineCompleter getArgumentCompleter() {
        return this.argsCompleter;
    }

    @Override
    public void handle(CommandContext ctx) {
        ModelControllerClient client;
        if (this.helpArg.isPresent(ctx.getParsedArguments())) {
            this.printHelp(ctx);
            return;
        }
        if (this.connectionRequired && (client = ctx.getModelControllerClient()) == null) {
            ctx.printLine("The controller client is not available. Make sure you are connected.");
            return;
        }
        this.doHandle(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printHelp(CommandContext ctx) {
        InputStream helpInput = SecurityActions.getClassLoader(CommandHandlerWithHelp.class).getResourceAsStream(this.filename);
        if (helpInput != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(helpInput));
            try {
                String helpLine = reader.readLine();
                while (helpLine != null) {
                    ctx.printLine(helpLine);
                    helpLine = reader.readLine();
                }
            }
            catch (IOException e) {
                ctx.printLine("Failed to read help/help.txt: " + e.getLocalizedMessage());
            }
            finally {
                StreamUtils.safeClose((Closeable)reader);
            }
        } else {
            ctx.printLine("Failed to locate command description " + this.filename);
        }
    }

    protected abstract void doHandle(CommandContext var1);

    @Override
    public boolean isBatchMode() {
        return false;
    }

    protected void printList(CommandContext ctx, List<String> list, boolean l) {
        if (l) {
            for (String item : list) {
                ctx.printLine(item);
            }
        } else {
            ctx.printColumns(list);
        }
    }
}

