/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class CreateJmsQueueHandler
extends BatchModeCommandHandler {
    private final ArgumentWithValue name;
    private final ArgumentWithValue entries;
    private final ArgumentWithValue selector;
    private final ArgumentWithValue durable;
    private final ArgumentWithValue profile;

    public CreateJmsQueueHandler() {
        super("create-jms-queue", true);
        SimpleArgumentTabCompleter argsCompleter = (SimpleArgumentTabCompleter)this.getArgumentCompleter();
        this.profile = new ArgumentWithValue((CommandLineCompleter)new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), new String[]{"--profile"}){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        argsCompleter.addArgument(this.profile);
        this.name = new ArgumentWithValue(true, new String[]{"--name"}){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                if (ctx.isDomainMode() && !CreateJmsQueueHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        argsCompleter.addArgument(this.name);
        this.entries = new ArgumentWithValue("--entries");
        argsCompleter.addArgument(this.entries);
        this.selector = new ArgumentWithValue("--selector");
        argsCompleter.addArgument(this.selector);
        this.durable = new ArgumentWithValue(new SimpleTabCompleter(new String[]{"false", "true"}), "--durable");
        argsCompleter.addArgument(this.durable);
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (OperationFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to perform operation: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("Sucessfully created queue.");
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        String durable;
        String name;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        ParsedArguments args = ctx.getParsedArguments();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("--profile argument value is missing.");
            }
            builder.addNode("profile", profile);
        }
        try {
            name = this.name.getValue(args);
        }
        catch (IllegalArgumentException e) {
            throw new OperationFormatException(e.getLocalizedMessage());
        }
        builder.addNode("subsystem", "jms");
        builder.addNode("queue", name);
        builder.setOperationName("add");
        ModelNode entriesNode = builder.getModelNode().get("entries");
        String entriesStr = this.entries.getValue(args);
        if (entriesStr == null) {
            entriesNode.add(name);
        } else {
            String[] split = entriesStr.split(",");
            for (int i = 0; i < split.length; ++i) {
                String entry = split[i].trim();
                if (entry.isEmpty()) continue;
                entriesNode.add(entry);
            }
        }
        String selector = this.selector.getValue(args);
        if (selector != null) {
            builder.addProperty("selector", selector);
        }
        if ((durable = this.durable.getValue(args)) != null) {
            builder.addProperty("durable", durable);
        }
        return builder.buildRequest();
    }
}

