/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithoutValue;

public class HistoryHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithoutValue clear;
    private final ArgumentWithoutValue disable;
    private final ArgumentWithoutValue enable;

    public HistoryHandler() {
        this("history");
    }

    public HistoryHandler(String command) {
        super(command);
        SimpleArgumentTabCompleter argsCompleter = (SimpleArgumentTabCompleter)this.getArgumentCompleter();
        this.clear = new ArgumentWithoutValue("--clear");
        this.clear.setExclusive(true);
        argsCompleter.addArgument(this.clear);
        this.disable = new ArgumentWithoutValue("--disable");
        this.disable.setExclusive(true);
        argsCompleter.addArgument(this.disable);
        this.enable = new ArgumentWithoutValue("--enable");
        this.enable.setExclusive(true);
        argsCompleter.addArgument(this.enable);
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ParsedArguments args = ctx.getParsedArguments();
        if (!args.hasArguments()) {
            HistoryHandler.printHistory(ctx);
            return;
        }
        if (this.clear.isPresent(args)) {
            ctx.getHistory().clear();
        } else if (this.disable.isPresent(args)) {
            ctx.getHistory().setUseHistory(false);
        } else if (this.enable.isPresent(args)) {
            ctx.getHistory().setUseHistory(true);
        } else {
            ctx.printLine("Unexpected argument '" + ctx.getArgumentsString() + '\'');
        }
    }

    private static void printHistory(CommandContext ctx) {
        CommandHistory history = ctx.getHistory();
        List<String> list = history.asList();
        for (String cmd : list) {
            ctx.printLine(cmd);
        }
        ctx.printLine("(The history is currently " + (history.isUseHistory() ? "enabled)" : "disabled)"));
    }
}

