/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;

public class PrefixHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue nodePath;

    public PrefixHandler() {
        this("cn");
    }

    public PrefixHandler(String command) {
        super(command, true);
        SimpleArgumentTabCompleter argsCompleter = (SimpleArgumentTabCompleter)this.getArgumentCompleter();
        this.nodePath = new ArgumentWithValue(false, (CommandLineCompleter)OperationRequestCompleter.INSTANCE, 0, "--node-path");
        argsCompleter.addArgument(this.nodePath);
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        String nodePath = this.nodePath.getValue(ctx.getParsedArguments());
        OperationRequestAddress prefix = ctx.getPrefix();
        if (nodePath == null) {
            ctx.printLine(ctx.getPrefixFormatter().format(prefix));
            return;
        }
        DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(prefix);
        try {
            ctx.getOperationRequestParser().parse(ctx.getArgumentsString(), handler);
        }
        catch (CommandFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
        }
    }
}

