/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.List;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.impl.ArgumentWithoutValue;

public class ArgumentWithValue
extends ArgumentWithoutValue {
    private final boolean required;
    private final CommandLineCompleter valueCompleter;

    public ArgumentWithValue(String ... names) {
        this(false, -1, names);
    }

    public ArgumentWithValue(CommandLineCompleter valueCompleter, String ... names) {
        this(false, valueCompleter, -1, names);
    }

    public ArgumentWithValue(boolean required, CommandLineCompleter valueCompleter, String ... names) {
        this(required, valueCompleter, -1, names);
    }

    public ArgumentWithValue(boolean required, String ... names) {
        this(required, -1, names);
    }

    public ArgumentWithValue(int index, String defaultName) {
        this(false, index, defaultName);
    }

    public ArgumentWithValue(boolean required, int index, String ... names) {
        this(required, null, index, names);
    }

    public ArgumentWithValue(boolean required, CommandLineCompleter valueCompleter, int index, String ... names) {
        super(index, names);
        this.required = required;
        this.valueCompleter = valueCompleter;
    }

    @Override
    public CommandLineCompleter getValueCompleter() {
        return this.valueCompleter;
    }

    @Override
    public String getValue(ParsedArguments args) {
        String value = null;
        if (args.hasArguments()) {
            List<String> others;
            if (this.index >= 0 && (others = args.getOtherArguments()).size() > this.index) {
                value = others.get(this.index);
            }
            if (this.names != null) {
                if (this.names.length == 1) {
                    if (value == null) {
                        value = args.getArgument(this.names[0]);
                    } else {
                        String namedValue = args.getArgument(this.names[0]);
                        if (namedValue != null && !namedValue.equals(value)) {
                            throw new IllegalArgumentException("Argument " + this.defaultName + " is specified twice: '" + value + "' vs '" + namedValue + "'.");
                        }
                    }
                } else {
                    for (String name : this.names) {
                        if (value == null) {
                            value = args.getArgument(name);
                            continue;
                        }
                        String namedValue = args.getArgument(name);
                        if (namedValue == null || namedValue.equals(value)) continue;
                        throw new IllegalArgumentException("Argument " + this.defaultName + " is specified twice: '" + value + "' vs '" + namedValue + "'.");
                    }
                }
            }
        }
        if (this.required && value == null && !this.isPresent(args)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Required argument ");
            if (this.names != null) {
                buf.append('\'').append(this.names[0]).append('\'');
            } else {
                buf.append("with index ").append(this.index);
            }
            buf.append(" is missing.");
            throw new IllegalArgumentException(buf.toString());
        }
        return value;
    }

    @Override
    public boolean isValueRequired() {
        return true;
    }
}

