/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.parsing.CommandLineParser;

public class DefaultParsedArguments
implements ParsedArguments {
    private String argsStr;
    private Map<String, String> namedArgs;
    private List<String> otherArgs;

    public void reset(String args) {
        this.argsStr = args;
        this.namedArgs = null;
        this.otherArgs = null;
    }

    public void parse(String args) {
        this.argsStr = args;
        this.namedArgs = null;
        this.otherArgs = null;
        this.parseArgs();
    }

    @Override
    public String getArgumentsString() {
        return this.argsStr;
    }

    @Override
    public boolean hasArguments() {
        if (this.otherArgs == null) {
            this.parseArgs();
        }
        return !this.namedArgs.isEmpty() || !this.otherArgs.isEmpty();
    }

    @Override
    public boolean hasArgument(String argName) {
        if (this.namedArgs == null) {
            this.parseArgs();
        }
        return this.namedArgs.containsKey(argName);
    }

    @Override
    public String getArgument(String argName) {
        if (this.namedArgs == null) {
            this.parseArgs();
        }
        return this.namedArgs.get(argName);
    }

    @Override
    public Set<String> getArgumentNames() {
        if (this.namedArgs == null) {
            this.parseArgs();
        }
        return this.namedArgs.keySet();
    }

    @Override
    public List<String> getOtherArguments() {
        if (this.otherArgs == null) {
            this.parseArgs();
        }
        return this.otherArgs;
    }

    private void parseArgs() {
        this.namedArgs = null;
        this.otherArgs = null;
        if (this.argsStr != null && !this.argsStr.isEmpty()) {
            try {
                CommandLineParser.parse(this.argsStr, new CommandLineParser.CallbackHandler(){

                    @Override
                    public void argument(String name, int nameStart, String value, int valueStart, int leaveIndex) {
                        if (name != null) {
                            if (DefaultParsedArguments.this.namedArgs == null) {
                                DefaultParsedArguments.this.namedArgs = Collections.singletonMap(name, value);
                            } else {
                                if (DefaultParsedArguments.this.namedArgs.size() == 1) {
                                    DefaultParsedArguments.this.namedArgs = new HashMap(DefaultParsedArguments.this.namedArgs);
                                }
                                DefaultParsedArguments.this.namedArgs.put(name, value);
                            }
                        } else if (value != null) {
                            if (DefaultParsedArguments.this.otherArgs == null) {
                                DefaultParsedArguments.this.otherArgs = Collections.singletonList(value);
                            } else {
                                if (DefaultParsedArguments.this.otherArgs.size() == 1) {
                                    DefaultParsedArguments.this.otherArgs = new ArrayList(DefaultParsedArguments.this.otherArgs);
                                }
                                DefaultParsedArguments.this.otherArgs.add(value);
                            }
                        }
                    }
                });
            }
            catch (CommandLineException commandLineException) {
                // empty catch block
            }
        }
        if (this.namedArgs == null) {
            this.namedArgs = Collections.emptyMap();
        }
        if (this.otherArgs == null) {
            this.otherArgs = Collections.emptyList();
        }
    }
}

