/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.parsing;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.parsing.CharacterHandler;
import org.jboss.as.cli.operation.parsing.DefaultParsingState;
import org.jboss.as.cli.operation.parsing.ParsingContext;
import org.jboss.as.cli.operation.parsing.ParsingState;
import org.jboss.as.cli.operation.parsing.ParsingStateCallbackHandler;

public class StateParser {
    private final DefaultParsingState initialState = new DefaultParsingState("INITIAL");

    public void addState(char ch, ParsingState state) {
        this.initialState.enterState(ch, state);
    }

    public void parse(String str, ParsingStateCallbackHandler callbackHandler) throws OperationFormatException {
        StateParser.parse(str, callbackHandler, this.initialState);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState) throws OperationFormatException {
        int i;
        if (str == null || str.isEmpty()) {
            return;
        }
        for (i = 0; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
        }
        if (i == str.length()) {
            return;
        }
        ParsingContextImpl ctx = new ParsingContextImpl();
        ctx.initialState = initialState;
        ctx.callbackHandler = callbackHandler;
        while (i < str.length()) {
            char ch;
            ctx.ch = ch = str.charAt(i);
            ctx.location = i++;
            CharacterHandler handler = ctx.getState().getHandler(ch);
            handler.handle(ctx);
        }
        ctx.location = i;
        ParsingState state = ctx.getState();
        while (state != ctx.initialState) {
            state.getEndContentHandler().handle(ctx);
            ctx.leaveState();
            state = ctx.getState();
        }
    }

    static class ParsingContextImpl
    implements ParsingContext {
        private final Deque<ParsingState> stack = new ArrayDeque<ParsingState>();
        int location;
        char ch;
        ParsingStateCallbackHandler callbackHandler;
        ParsingState initialState;

        ParsingContextImpl() {
        }

        @Override
        public ParsingState getState() {
            return this.stack.isEmpty() ? this.initialState : this.stack.peek();
        }

        @Override
        public void enterState(ParsingState state) throws OperationFormatException {
            this.stack.push(state);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public ParsingState leaveState() throws OperationFormatException {
            this.callbackHandler.leavingState(this);
            this.stack.peek().getLeaveHandler().handle(this);
            ParsingState pop = this.stack.pop();
            if (!this.stack.isEmpty()) {
                this.stack.peek().getReturnHandler().handle(this);
            }
            return pop;
        }

        @Override
        public ParsingStateCallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public char getCharacter() {
            return this.ch;
        }

        @Override
        public int getLocation() {
            return this.location;
        }

        @Override
        public void reenterState() throws OperationFormatException {
            this.callbackHandler.leavingState(this);
            ParsingState state = this.stack.peek();
            state.getLeaveHandler().handle(this);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }
    }
}

