/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheAdd;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class DistributedCacheAdd
extends SharedStateCacheAdd {
    static final DistributedCacheAdd INSTANCE = new DistributedCacheAdd();

    static ModelNode createOperation(ModelNode address, ModelNode model) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        INSTANCE.populate(model, operation);
        return operation;
    }

    private DistributedCacheAdd() {
        super(CacheMode.DIST_SYNC);
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        super.populate(fromModel, toModel);
        CommonAttributes.OWNERS.validateAndSet(fromModel, toModel);
        CommonAttributes.VIRTUAL_NODES.validateAndSet(fromModel, toModel);
        CommonAttributes.L1_LIFESPAN.validateAndSet(fromModel, toModel);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, cache, builder, dependencies);
        int owners = CommonAttributes.OWNERS.resolveModelAttribute(context, cache).asInt();
        int virtualNodes = CommonAttributes.VIRTUAL_NODES.resolveModelAttribute(context, cache).asInt();
        long lifespan = CommonAttributes.L1_LIFESPAN.resolveModelAttribute(context, cache).asLong();
        builder.clustering().hash().numOwners(owners);
        builder.clustering().hash().numVirtualNodes(virtualNodes);
        if (lifespan > 0L) {
            builder.clustering().l1().lifespan(lifespan);
        } else {
            builder.clustering().l1().disable();
        }
    }
}

