/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.clustering.MarshallingContext;
import org.jboss.as.clustering.VersionedMarshallingConfiguration;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.SessionAttributeMarshaller;
import org.jboss.as.clustering.web.SessionAttributeMarshallerFactory;
import org.jboss.as.clustering.web.impl.ClusteringWebMessages;
import org.jboss.as.clustering.web.impl.SessionAttributeMarshallerImpl;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.ReflectiveCreator;
import org.jboss.marshalling.reflect.SunReflectiveCreator;

public class SessionAttributeMarshallerFactoryImpl
implements SessionAttributeMarshallerFactory,
ClassTable,
VersionedMarshallingConfiguration {
    private static final int CURRENT_VERSION = 1;
    private final MarshallerFactory factory;
    private final Map<Integer, MarshallingConfiguration> configurations = new ConcurrentHashMap<Integer, MarshallingConfiguration>();
    private static final Class<?>[] classes = new Class[]{Serializable.class, Externalizable.class};
    private static final Map<Class<?>, ClassTable.Writer> writers = SessionAttributeMarshallerFactoryImpl.createWriters();

    public SessionAttributeMarshallerFactoryImpl() {
        this(Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Marshalling.class.getClassLoader()));
    }

    public SessionAttributeMarshallerFactoryImpl(MarshallerFactory factory) {
        this.factory = factory;
    }

    @Override
    public SessionAttributeMarshaller createMarshaller(LocalDistributableSessionManager manager) {
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver(manager.getApplicationClassResolver());
        configuration.setSerializedCreator((Creator)new SunReflectiveCreator());
        configuration.setExternalizerCreator((Creator)new ReflectiveCreator());
        configuration.setClassTable((ClassTable)this);
        this.configurations.put(1, configuration);
        return new SessionAttributeMarshallerImpl(new MarshallingContext(this.factory, (VersionedMarshallingConfiguration)this));
    }

    public int getCurrentMarshallingVersion() {
        return 1;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        MarshallingConfiguration config = this.configurations.get(version);
        if (config == null) {
            throw ClusteringWebMessages.MESSAGES.unsupportedMarshallingVersion(version);
        }
        return config;
    }

    private static Map<Class<?>, ClassTable.Writer> createWriters() {
        IdentityHashMap writers = new IdentityHashMap();
        for (int i = 0; i < classes.length; ++i) {
            writers.put(classes[i], new ByteWriter((byte)i));
        }
        return writers;
    }

    public ClassTable.Writer getClassWriter(Class<?> targetClass) throws IOException {
        return writers.get(targetClass);
    }

    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int index = unmarshaller.readUnsignedByte();
        if (index >= classes.length) {
            throw ClusteringWebMessages.MESSAGES.classIndexNotFoundInClassTable(this.getClass().getName(), index);
        }
        return classes[index];
    }

    private static final class ByteWriter
    implements ClassTable.Writer {
        final byte[] bytes;

        ByteWriter(byte ... bytes) {
            this.bytes = bytes;
        }

        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.write(this.bytes);
        }
    }
}

