/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.jboss.as.clustering.ManagedExecutorService;
import org.jboss.as.clustering.ManagedScheduledExecutorService;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.ThreadFactoryAdapter;
import org.jboss.as.clustering.jgroups.TimerSchedulerAdapter;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.logging.Logger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;

public class JChannelFactory
implements ChannelFactory,
ChannelListener,
ProtocolStackConfigurator {
    private static final Logger log = Logger.getLogger(JChannelFactory.class);
    private final ProtocolStackConfiguration configuration;
    private final Map<Channel, String> channels = Collections.synchronizedMap(new WeakHashMap());

    public JChannelFactory(ProtocolStackConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(String id) throws Exception {
        JChannel channel = new JChannel(this);
        TP transport = channel.getProtocolStack().getTransport();
        if (transport.isSingleton()) {
            TP tP = transport;
            synchronized (tP) {
                this.init(transport);
            }
        } else {
            this.init(transport);
        }
        channel.setName(id);
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            try {
                this.channels.put((Channel)channel, id);
                JmxConfigurator.registerChannel((org.jgroups.JChannel)channel, (MBeanServer)server, (String)id);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            channel.addChannelListener(this);
        }
        return channel;
    }

    private void init(TP transport) {
        ScheduledExecutorService timerExecutor;
        ExecutorService oobExecutor;
        ExecutorService defaultExecutor;
        java.util.concurrent.ThreadFactory threadFactory;
        SocketFactory factory;
        TransportConfiguration transportConfig = this.configuration.getTransport();
        SocketBinding binding = transportConfig.getSocketBinding();
        if (binding != null && !((factory = transport.getSocketFactory()) instanceof ManagedSocketFactory)) {
            transport.setSocketFactory((SocketFactory)new ManagedSocketFactory(factory, binding.getSocketBindings()));
        }
        if ((threadFactory = transportConfig.getThreadFactory()) != null && !(transport.getThreadFactory() instanceof ThreadFactoryAdapter)) {
            transport.setThreadFactory((ThreadFactory)new ThreadFactoryAdapter(threadFactory));
        }
        if ((defaultExecutor = transportConfig.getDefaultExecutor()) != null && !(transport.getDefaultThreadPool() instanceof ManagedExecutorService)) {
            transport.setDefaultThreadPool((Executor)new ManagedExecutorService(defaultExecutor));
        }
        if ((oobExecutor = transportConfig.getOOBExecutor()) != null && !(transport.getOOBThreadPool() instanceof ManagedExecutorService)) {
            transport.setOOBThreadPool((Executor)new ManagedExecutorService(oobExecutor));
        }
        if ((timerExecutor = transportConfig.getTimerExecutor()) != null && !(transport.getTimer() instanceof TimerSchedulerAdapter)) {
            this.setValue((Protocol)transport, "timer", new TimerSchedulerAdapter(new ManagedScheduledExecutorService(timerExecutor)));
        }
    }

    public String getProtocolStackString() {
        return null;
    }

    public List<org.jgroups.conf.ProtocolConfiguration> getProtocolStack() {
        SocketBinding diagnosticsSocketBinding;
        SocketBinding socketBinding;
        ArrayList<org.jgroups.conf.ProtocolConfiguration> configs = new ArrayList<org.jgroups.conf.ProtocolConfiguration>(this.configuration.getProtocols().size() + 1);
        TransportConfiguration transport = this.configuration.getTransport();
        org.jgroups.conf.ProtocolConfiguration config = this.createProtocol(this.configuration.getTransport());
        Map properties = config.getProperties();
        if (transport.isShared() && !transport.getProperties().containsKey("singleton_name")) {
            properties.put("singleton_name", this.configuration.getName());
        }
        if ((socketBinding = transport.getSocketBinding()) != null) {
            properties.put("bind_addr", socketBinding.getSocketAddress().getAddress().getHostAddress());
            this.configureServerSocket(config, "bind_port", socketBinding);
            this.configureMulticastSocket(config, "mcast_addr", "mcast_port", socketBinding);
        }
        boolean diagnostics = (diagnosticsSocketBinding = transport.getDiagnosticsSocketBinding()) != null;
        properties.put("enable_diagnostics", String.valueOf(diagnostics));
        if (diagnostics) {
            this.configureMulticastSocket(config, "diagnostics_addr", "diagnostics_port", diagnosticsSocketBinding);
        }
        configs.add(config);
        for (ProtocolConfiguration protocol : this.configuration.getProtocols()) {
            config = this.createProtocol(protocol);
            socketBinding = protocol.getSocketBinding();
            if (socketBinding != null) {
                this.configureServerSocket(config, "start_port", socketBinding);
                this.configureMulticastSocket(config, "mcast_addr", "mcast_port", socketBinding);
            }
            configs.add(config);
        }
        return configs;
    }

    private void configureServerSocket(org.jgroups.conf.ProtocolConfiguration config, String portProperty, SocketBinding socketBinding) {
        config.getProperties().put(portProperty, String.valueOf(socketBinding.getSocketAddress().getPort()));
    }

    private void configureMulticastSocket(org.jgroups.conf.ProtocolConfiguration config, String addressProperty, String portProperty, SocketBinding socketBinding) {
        Map properties = config.getProperties();
        try {
            InetSocketAddress mcastSocketAddress = socketBinding.getMulticastSocketAddress();
            properties.put(addressProperty, mcastSocketAddress.getAddress().getHostAddress());
            properties.put(portProperty, String.valueOf(mcastSocketAddress.getPort()));
        }
        catch (IllegalStateException e) {
            log.tracef((Throwable)e, "Could not set %s.%s and %s.%s, %s socket binding does not specify a multicast socket", new Object[]{config.getProtocolName(), addressProperty, config.getProtocolName(), portProperty, socketBinding.getName()});
        }
    }

    private org.jgroups.conf.ProtocolConfiguration createProtocol(ProtocolConfiguration protocolConfig) {
        String protocol = protocolConfig.getName();
        final HashMap<String, String> properties = new HashMap<String, String>(this.configuration.getDefaults().getProperties(protocol));
        properties.putAll(protocolConfig.getProperties());
        return new org.jgroups.conf.ProtocolConfiguration(protocol, properties){

            public Map<String, String> getOriginalProperties() {
                return properties;
            }
        };
    }

    private void setValue(Protocol protocol, String property, Object value) {
        log.tracef("Setting %s.%s=%d", (Object)protocol.getName(), (Object)property, value);
        try {
            protocol.setValue(property, value);
        }
        catch (IllegalArgumentException e) {
            log.tracef((Throwable)e, "Failed to set non-existent %s.%s=%d", (Object)protocol.getName(), (Object)property, value);
        }
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    public void channelClosed(Channel channel) {
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            try {
                JmxConfigurator.unregisterChannel((org.jgroups.JChannel)((JChannel)channel), (MBeanServer)server, (String)this.channels.remove(channel));
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated
    public void channelShunned() {
    }

    @Deprecated
    public void channelReconnected(Address addr) {
    }

    public static class JChannel
    extends org.jgroups.JChannel {
        JChannel(ProtocolStackConfigurator configurator) throws ChannelException {
            super(configurator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(String clusterName, boolean useFlushIfPresent) throws ChannelException {
            TP transport = this.getProtocolStack().getTransport();
            if (transport.isSingleton()) {
                TP tP = transport;
                synchronized (tP) {
                    super.connect(clusterName, useFlushIfPresent);
                }
            } else {
                super.connect(clusterName, useFlushIfPresent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(String clusterName, Address target, String stateId, long timeout, boolean useFlushIfPresent) throws ChannelException {
            TP transport = this.getProtocolStack().getTransport();
            if (transport.isSingleton()) {
                TP tP = transport;
                synchronized (tP) {
                    super.connect(clusterName, target, stateId, timeout, useFlushIfPresent);
                }
            } else {
                super.connect(clusterName, target, stateId, timeout, useFlushIfPresent);
            }
        }
    }
}

