/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.client.Cancellable;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationResult;
import org.jboss.as.controller.client.ResultHandler;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.DuplicateDeploymentNameException;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentActionImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentContentDistributor;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DomainClientImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DomainDeploymentPlanResultFuture;
import org.jboss.as.controller.client.helpers.domain.impl.InitialDeploymentPlanBuilderFactory;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

class DomainDeploymentManagerImpl
implements DomainDeploymentManager {
    private final DomainClientImpl client;
    private final DeploymentContentDistributor contentDistributor;

    DomainDeploymentManagerImpl(DomainClientImpl client) {
        assert (client != null) : "client is null";
        this.client = client;
        this.contentDistributor = new DeploymentContentDistributor(){

            @Override
            public byte[] distributeDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
                boolean unique = DomainDeploymentManagerImpl.this.client.isDeploymentNameUnique(name);
                if (!unique) {
                    throw new DuplicateDeploymentNameException(name, false);
                }
                return DomainDeploymentManagerImpl.this.client.addDeploymentContent(stream);
            }

            @Override
            public byte[] distributeReplacementDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException {
                return DomainDeploymentManagerImpl.this.client.addDeploymentContent(stream);
            }
        };
    }

    @Override
    public Future<DeploymentPlanResult> execute(DeploymentPlan plan) {
        if (!(plan instanceof DeploymentPlanImpl)) {
            throw new IllegalArgumentException("Cannot use a DeploymentPlan not created by this manager");
        }
        DeploymentPlanImpl planImpl = (DeploymentPlanImpl)DeploymentPlanImpl.class.cast(plan);
        HashMap<UUID, String> actionsById = new HashMap<UUID, String>();
        Operation operation = this.getDeploymentPlanOperation(planImpl, actionsById);
        Handler handler = new Handler(operation);
        OperationResult c = this.client.execute(operation, handler.resultHandler);
        handler.setCancellable(c.getCancellable());
        return new DomainDeploymentPlanResultFuture(planImpl, handler, actionsById);
    }

    @Override
    public InitialDeploymentPlanBuilder newDeploymentPlan() {
        return InitialDeploymentPlanBuilderFactory.newInitialDeploymentPlanBuilder(this.contentDistributor);
    }

    private Operation getDeploymentPlanOperation(DeploymentPlanImpl plan, Map<UUID, String> actionsById) {
        Operation op = this.getCompositeOperation(plan, actionsById);
        this.addRollbackPlan(plan, op);
        return op;
    }

    private Operation getCompositeOperation(DeploymentPlanImpl plan, Map<UUID, String> actionsById) {
        Set<String> deployments = this.getCurrentDomainDeployments();
        Set<String> serverGroups = this.getServerGroupNames(plan);
        ModelNode op = new ModelNode();
        op.get("operation").set("composite");
        op.get("address").setEmptyList();
        ModelNode steps = op.get("steps");
        steps.setEmptyList();
        op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(plan.isSingleServerRollback());
        OperationBuilder builder = OperationBuilder.Factory.create(op);
        int stepNum = 1;
        for (DeploymentActionImpl action : plan.getDeploymentActionImpls()) {
            actionsById.put(action.getId(), "step-" + stepNum);
            ++stepNum;
            ArrayList<ModelNode> actionSteps = new ArrayList<ModelNode>();
            String uniqueName = action.getDeploymentUnitUniqueName();
            switch (action.getType()) {
                case ADD: {
                    ModelNode groupStep;
                    ModelNode step;
                    if (!deployments.contains(uniqueName)) {
                        step = this.configureDeploymentOperation("add", uniqueName, null);
                        step.get("runtime-name").set(action.getNewContentFileName());
                        step.get("content").get(0).get("hash").set(action.getNewContentHash());
                        actionSteps.add(step);
                    }
                    for (String group : serverGroups) {
                        groupStep = this.configureDeploymentOperation("add", uniqueName, group);
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                case DEPLOY: {
                    ModelNode groupStep;
                    for (String group : serverGroups) {
                        groupStep = this.configureDeploymentOperation("deploy", uniqueName, group);
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                case FULL_REPLACE: {
                    ModelNode step = new ModelNode();
                    step.get("operation").set("full-replace-deployment");
                    step.get("address").setEmptyList();
                    step.get("name").set(uniqueName);
                    step.get("runtime-name").set(action.getNewContentFileName());
                    step.get("content").get(0).get("hash").set(action.getNewContentHash());
                    actionSteps.add(step);
                    break;
                }
                case REDEPLOY: {
                    ModelNode groupStep;
                    for (String group : serverGroups) {
                        groupStep = this.configureDeploymentOperation("redeploy", uniqueName, group);
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                case REMOVE: {
                    ModelNode groupStep;
                    for (String group : serverGroups) {
                        groupStep = this.configureDeploymentOperation("remove", uniqueName, group);
                        actionSteps.add(groupStep);
                    }
                    ModelNode step = this.configureDeploymentOperation("remove", uniqueName, null);
                    actionSteps.add(step);
                    break;
                }
                case REPLACE: {
                    ModelNode groupStep;
                    for (String group : serverGroups) {
                        groupStep = new ModelNode();
                        groupStep.get("operation").set("replace-deployment");
                        groupStep.get("address").add("server-group", group);
                        groupStep.get("name").set(uniqueName);
                        groupStep.get("to-replace").set(action.getReplacedDeploymentUnitUniqueName());
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                case UNDEPLOY: {
                    ModelNode groupStep;
                    for (String group : serverGroups) {
                        groupStep = this.configureDeploymentOperation("undeploy", uniqueName, group);
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown action type " + (Object)((Object)action.getType()));
                }
            }
            for (ModelNode actionStep : actionSteps) {
                steps.add(actionStep);
            }
        }
        return builder.build();
    }

    private Set<String> getCurrentDomainDeployments() {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("deployment");
        ModelNode rsp = this.client.executeForResult(OperationBuilder.Factory.create(op).build());
        HashSet<String> deployments = new HashSet<String>();
        if (rsp.isDefined()) {
            for (ModelNode node : rsp.asList()) {
                deployments.add(node.asString());
            }
        }
        return deployments;
    }

    private void addRollbackPlan(DeploymentPlanImpl plan, Operation op) {
        ModelNode opNode = op.getOperation();
        ModelNode rolloutPlan = opNode.get(new String[]{"operation-headers", "rollout-plan"});
        rolloutPlan.get("rollback-across-groups").set(plan.isRollbackAcrossGroups());
        ModelNode series = rolloutPlan.get("in-series");
        for (Set<ServerGroupDeploymentPlan> concurrent : plan.getServerGroupDeploymentPlans()) {
            if (concurrent.size() == 1) {
                ModelNode single = new ModelNode();
                ServerGroupDeploymentPlan sgdp = concurrent.iterator().next();
                single.get(new String[]{"server-group", sgdp.getServerGroupName()}).set(this.createServerGroupPlan(sgdp));
                series.add(single);
                continue;
            }
            ModelNode multiple = new ModelNode();
            for (ServerGroupDeploymentPlan sgdp : concurrent) {
                multiple.get(new String[]{"concurrent-groups", sgdp.getServerGroupName()}).set(this.createServerGroupPlan(sgdp));
            }
            series.add(multiple);
        }
    }

    private ModelNode createServerGroupPlan(ServerGroupDeploymentPlan sgdp) {
        ModelNode result = new ModelNode();
        result.get("rolling-to-servers").set(sgdp.isRollingToServers());
        if (sgdp.isRollback()) {
            if (sgdp.getMaxServerFailurePercentage() > 0) {
                result.get("max-failure-percentage").set(sgdp.getMaxServerFailurePercentage());
            } else {
                result.get("max-failed-servers").set(sgdp.getMaxServerFailures());
            }
        } else {
            result.get("max-failure-percentage").set(100);
        }
        return result;
    }

    private Set<String> getServerGroupNames(DeploymentPlan plan) {
        HashSet<String> names = new HashSet<String>();
        for (Set<ServerGroupDeploymentPlan> sgdps : plan.getServerGroupDeploymentPlans()) {
            for (ServerGroupDeploymentPlan sgdp : sgdps) {
                names.add(sgdp.getServerGroupName());
            }
        }
        return names;
    }

    private ModelNode configureDeploymentOperation(String operationName, String uniqueName, String serverGroup) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (serverGroup != null) {
            op.get("address").add("server-group", serverGroup);
        }
        op.get("address").add("deployment", uniqueName);
        return op;
    }

    private static class Handler
    implements Future<ModelNode> {
        private final Operation operation;
        private AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
        private final Thread runner = Thread.currentThread();
        private final ModelNode result = new ModelNode();
        private Cancellable cancellable;
        private final AtomicReference<Exception> exception = new AtomicReference();
        private final ResultHandler resultHandler = new ResultHandler(){

            @Override
            public void handleResultFragment(String[] location, ModelNode fragment) {
                if (Handler.this.state.get() == State.RUNNING) {
                    Handler.this.result.get(location).set(fragment);
                }
            }

            @Override
            public void handleResultComplete() {
                Handler.this.state.compareAndSet(State.RUNNING, State.DONE);
                Handler.this.cleanUpAndNotify();
            }

            @Override
            public void handleCancellation() {
                Handler.this.state.compareAndSet(State.RUNNING, State.CANCELLED);
                Handler.this.cleanUpAndNotify();
            }

            @Override
            public void handleFailed(ModelNode failureDescription) {
                String message = failureDescription.isDefined() ? failureDescription.toString() : "Operation failed with no failure description";
                Exception e = new Exception(message);
                Handler.this.exception.compareAndSet(null, e);
                Handler.this.state.compareAndSet(State.RUNNING, State.DONE);
                Handler.this.cleanUpAndNotify();
            }
        };

        private Handler(Operation operation) {
            this.operation = operation;
        }

        synchronized void cleanUpAndNotify() {
            for (InputStream in : this.operation.getInputStreams()) {
                StreamUtils.safeClose((Closeable)in);
            }
            this.notifyAll();
        }

        void setCancellable(Cancellable c) {
            this.cancellable = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = false;
            if (this.state.get() == State.RUNNING) {
                try {
                    if (this.cancellable.cancel()) {
                        cancelled = this.state.compareAndSet(State.RUNNING, State.CANCELLED);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!cancelled) {
                    if (mayInterruptIfRunning) {
                        this.runner.interrupt();
                    }
                    if (this.state.compareAndSet(State.RUNNING, State.DONE)) {
                        this.exception.set(new CancellationException());
                    }
                }
            }
            Handler handler = this;
            synchronized (handler) {
                this.notifyAll();
            }
            return cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.state.get() == State.CANCELLED;
        }

        @Override
        public boolean isDone() {
            return this.state.get() != State.RUNNING;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ModelNode get() throws InterruptedException, ExecutionException {
            Handler handler = this;
            synchronized (handler) {
                while (!this.isDone()) {
                    this.wait();
                }
                return this.getResult();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ModelNode get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long toWait = unit.toMillis(timeout);
            long expire = System.currentTimeMillis() + toWait;
            Handler handler = this;
            synchronized (handler) {
                while (!this.isDone()) {
                    this.wait(toWait);
                    if (this.isDone()) continue;
                    long now = System.currentTimeMillis();
                    if (now >= expire) {
                        throw new TimeoutException();
                    }
                    toWait = expire - now;
                }
                return this.getResult();
            }
        }

        private ModelNode getResult() throws ExecutionException {
            Exception e = this.exception.get();
            if (e instanceof ExecutionException) {
                throw (ExecutionException)e;
            }
            if (e instanceof CancellationException) {
                throw (CancellationException)e;
            }
            if (e != null) {
                throw new ExecutionException(e);
            }
            if (this.state.get() == State.CANCELLED) {
                throw new CancellationException();
            }
            return this.result;
        }

        private static enum State {
            RUNNING,
            CANCELLED,
            DONE;

        }
    }
}

