/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.DelegatingImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.BatchServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class OperationContextImpl
implements OperationContext {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");
    private final ModelControllerImpl modelController;
    private final OperationContext.Type contextType;
    private final EnumSet<ContextFlag> contextFlags;
    private final OperationMessageHandler messageHandler;
    private final Thread initiatingThread;
    private final EnumMap<OperationContext.Stage, Deque<Step>> steps;
    private final ModelController.OperationTransactionControl transactionControl;
    private final ServiceTarget serviceTarget;
    private final Map<ServiceName, ServiceController<?>> realRemovingControllers = new HashMap();
    private final boolean booting;
    private final OperationAttachments attachments;
    private final ControlledProcessState processState;
    private final Set<PathAddress> affectsModel;
    private boolean affectsResourceRegistration;
    private boolean respectInterruption = true;
    private PathAddress modelAddress;
    private OperationContext.Stage currentStage = OperationContext.Stage.MODEL;
    private ModelNode response;
    private ModelNode operation;
    private Resource model;
    private OperationContext.ResultAction resultAction;
    private boolean affectsRuntime;
    private boolean cancelled;
    private int depth;
    private int lockDepth;
    private int containerMonitorDepth;
    private StampHolder restartStampHolder;

    OperationContextImpl(ModelControllerImpl modelController, OperationContext.Type contextType, EnumSet<ContextFlag> contextFlags, OperationMessageHandler messageHandler, OperationAttachments attachments, Resource model, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, boolean booting) {
        this.contextType = contextType;
        this.transactionControl = transactionControl;
        this.booting = booting;
        this.model = model;
        this.modelController = modelController;
        this.messageHandler = messageHandler;
        this.attachments = attachments;
        this.processState = processState;
        this.response = new ModelNode().setEmptyObject();
        this.steps = new EnumMap(OperationContext.Stage.class);
        for (OperationContext.Stage stage : OperationContext.Stage.values()) {
            this.steps.put(stage, new ArrayDeque());
        }
        this.affectsModel = new HashSet<PathAddress>(1);
        this.initiatingThread = Thread.currentThread();
        this.contextFlags = contextFlags;
        this.serviceTarget = new ContextServiceTarget(modelController);
    }

    @Override
    public InputStream getAttachmentStream(int index) {
        if (this.attachments == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (InputStream)this.attachments.getInputStreams().get(index);
    }

    @Override
    public int getAttachmentStreamCount() {
        return this.attachments == null ? 0 : this.attachments.getInputStreams().size();
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(this.response, this.operation, step, stage);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(this.response, operation, step, stage);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        assert (Thread.currentThread() == this.initiatingThread);
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (operation == null) {
            throw new IllegalArgumentException("operation is null");
        }
        if (step == null) {
            throw new IllegalArgumentException("step is null");
        }
        if (stage == null) {
            throw new IllegalArgumentException("stage is null");
        }
        if (this.currentStage == OperationContext.Stage.DONE) {
            throw new IllegalStateException("Operation already complete");
        }
        if (stage.compareTo(this.currentStage) < 0 && (stage != OperationContext.Stage.IMMEDIATE || this.currentStage == OperationContext.Stage.DONE)) {
            throw new IllegalStateException("Stage " + (Object)((Object)stage) + " is already complete");
        }
        if (this.contextType == OperationContext.Type.MANAGEMENT && stage.compareTo(OperationContext.Stage.MODEL) > 0) {
            throw new IllegalArgumentException("Invalid step stage for this context type");
        }
        if (stage == OperationContext.Stage.DOMAIN && this.contextType != OperationContext.Type.HOST) {
            throw new IllegalStateException("Stage " + (Object)((Object)stage) + " is not valid for context type " + (Object)((Object)this.contextType));
        }
        if (stage == OperationContext.Stage.DONE) {
            throw new IllegalArgumentException("Invalid step stage specified");
        }
        if (stage == OperationContext.Stage.IMMEDIATE) {
            this.steps.get((Object)this.currentStage).addFirst(new Step(step, response, operation));
        } else {
            this.steps.get((Object)stage).addLast(new Step(step, response, operation));
        }
    }

    @Override
    public ModelNode getFailureDescription() {
        return this.response.get("failure-description");
    }

    @Override
    public boolean hasFailureDescription() {
        return this.response.has("failure-description");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationContext.ResultAction completeStep() {
        try {
            OperationContext.ResultAction action = this.doCompleteStep();
            if (action == OperationContext.ResultAction.KEEP) {
                this.report(MessageSeverity.INFO, "Operation succeeded, committing");
            } else {
                this.report(MessageSeverity.INFO, "Operation rolling back");
            }
            OperationContext.ResultAction resultAction = action;
            return resultAction;
        }
        finally {
            this.respectInterruption = false;
        }
    }

    private OperationContext.ResultAction doCompleteStep() {
        assert (Thread.currentThread() == this.initiatingThread);
        if (this.currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (Thread.currentThread().isInterrupted()) {
            this.cancelled = true;
        }
        ModelNode response = this.response;
        if (this.cancelled) {
            response.get("outcome").set("cancelled");
            response.get("failure-description").set("Operation cancelled");
            response.get("rolled-back").set(true);
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
            return this.resultAction;
        }
        if (response.hasDefined("failure-description") && (this.contextFlags.contains((Object)ContextFlag.ROLLBACK_ON_FAIL) || this.currentStage == OperationContext.Stage.MODEL)) {
            response.get("outcome").set("failed");
            response.get("rolled-back").set(true);
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
            return this.resultAction;
        }
        if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
            return OperationContext.ResultAction.ROLLBACK;
        }
        Step step = null;
        do {
            if ((step = this.steps.get((Object)this.currentStage).pollFirst()) == null) {
                if (!this.currentStage.hasNext()) continue;
                this.currentStage = this.currentStage.next();
                if (this.contextType == OperationContext.Type.MANAGEMENT && this.currentStage == OperationContext.Stage.MODEL.next()) {
                    this.currentStage = OperationContext.Stage.DONE;
                    continue;
                }
                if (!this.affectsRuntime || this.currentStage != OperationContext.Stage.VERIFY) continue;
                try {
                    this.modelController.awaitContainerMonitor(true, 1);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.cancelled = true;
                    response.get("outcome").set("cancelled");
                    response.get("failure-description").set("Operation cancelled");
                    response.get("rolled-back").set(true);
                    return OperationContext.ResultAction.ROLLBACK;
                }
            } else {
                return this.executeStep(step);
            }
        } while (this.currentStage != OperationContext.Stage.DONE);
        final AtomicReference<OperationContext.ResultAction> ref = new AtomicReference<OperationContext.ResultAction>(this.transactionControl == null ? OperationContext.ResultAction.KEEP : OperationContext.ResultAction.ROLLBACK);
        ConfigurationPersister.PersistenceResource persistenceResource = null;
        if (this.isModelAffected() && this.resultAction != OperationContext.ResultAction.ROLLBACK) {
            try {
                persistenceResource = this.modelController.writeModel(this.model, this.affectsModel);
            }
            catch (ConfigurationPersistenceException e) {
                response.get("outcome").set("failed");
                response.get("failure-description").set("Failed to persist configuration change: " + e);
                this.resultAction = OperationContext.ResultAction.ROLLBACK;
                return this.resultAction;
            }
        }
        if (this.transactionControl != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Prepared response is " + response));
            }
            this.transactionControl.operationPrepared(new ModelController.OperationTransaction(){

                @Override
                public void commit() {
                    ref.set(OperationContext.ResultAction.KEEP);
                }

                @Override
                public void rollback() {
                    ref.set(OperationContext.ResultAction.ROLLBACK);
                }
            }, response);
        }
        this.resultAction = ref.get();
        if (persistenceResource != null) {
            if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                persistenceResource.rollback();
            } else {
                persistenceResource.commit();
            }
        }
        return this.resultAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationContext.ResultAction executeStep(Step step) {
        PathAddress oldModelAddress = this.modelAddress;
        ModelNode oldOperation = this.operation;
        ModelNode oldResponse = this.response;
        StampHolder oldRestartStamp = this.restartStampHolder;
        OperationContext.Stage stepStage = null;
        ModelNode response = null;
        try {
            ++this.depth;
            response = this.response = step.response;
            this.restartStampHolder = step.restartStamp;
            ModelNode newOperation = this.operation = step.operation;
            this.modelAddress = PathAddress.pathAddress(newOperation.get("address"));
            try {
                ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(step.getClass());
                try {
                    step.handler.execute(this, newOperation);
                }
                finally {
                    SecurityActions.setThreadContextClassLoader(oldTccl);
                }
            }
            catch (OperationFailedException ofe) {
                if (this.currentStage != OperationContext.Stage.DONE) {
                    response.get("failure-description").set(ofe.getFailureDescription());
                    log.errorf("Operation (%s) failed - address: (%s) - failure description: %s", (Object)this.operation.get("operation"), (Object)this.operation.get("address"), (Object)response.get("failure-description"));
                    this.completeStep();
                }
                throw ofe;
            }
            assert (this.resultAction != null);
        }
        catch (Throwable t) {
            log.errorf(t, "Operation (%s) failed - address: (%s)", (Object)this.operation.get("operation"), (Object)this.operation.get("address"));
            if (this.currentStage != OperationContext.Stage.DONE) {
                if (!response.hasDefined("failure-description")) {
                    response.get("failure-description").set("Operation handler failed: " + t);
                }
                response.get("outcome").set("failed");
                this.resultAction = this.getFailedResultAction(t);
                if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                    response.get("rolled-back").set(true);
                }
                OperationContext.ResultAction resultAction = this.resultAction;
                return resultAction;
            }
            if (this.resultAction != OperationContext.ResultAction.KEEP) {
                response.get("rolled-back").set(true);
            }
            response.get("outcome").set(response.hasDefined("failure-description") ? "failed" : "success");
            this.report(MessageSeverity.WARN, "Step handler " + step.handler + " failed after completion");
            OperationContext.ResultAction resultAction = this.resultAction;
            return resultAction;
        }
        finally {
            this.modelAddress = oldModelAddress;
            this.operation = oldOperation;
            this.response = oldResponse;
            this.restartStampHolder = oldRestartStamp;
            if (this.lockDepth == this.depth) {
                this.modelController.releaseLock();
                this.lockDepth = 0;
            }
            if (this.containerMonitorDepth == this.depth) {
                this.awaitContainerMonitor();
                this.modelController.releaseContainerMonitor();
                this.containerMonitorDepth = 0;
            }
            stepStage = this.currentStage;
            if (--this.depth == 0) {
                this.currentStage = null;
            }
        }
        if (stepStage != OperationContext.Stage.DONE) {
            OperationContext.Stage stage = this.currentStage = this.currentStage != null ? OperationContext.Stage.DONE : null;
            if (!response.hasDefined("failure-description")) {
                response.get("failure-description").set("Operation handler failed to complete");
            }
            response.get("outcome").set("failed");
            response.get("rolled-back").set(true);
            this.resultAction = this.getFailedResultAction(null);
            return this.resultAction;
        }
        response.get("outcome").set(response.hasDefined("failure-description") ? "failed" : "success");
        if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
            response.get("outcome").set("failed");
            response.get("rolled-back").set(true);
        }
        return this.resultAction;
    }

    private OperationContext.ResultAction getFailedResultAction(Throwable cause) {
        if (this.currentStage == OperationContext.Stage.MODEL || this.cancelled || this.contextFlags.contains((Object)ContextFlag.ROLLBACK_ON_FAIL) || this.isRollbackOnly() || cause != null && !(cause instanceof OperationFailedException)) {
            return OperationContext.ResultAction.ROLLBACK;
        }
        return OperationContext.ResultAction.KEEP;
    }

    @Override
    public OperationContext.Type getType() {
        assert (Thread.currentThread() == this.initiatingThread);
        return this.contextType;
    }

    @Override
    public boolean isBooting() {
        return this.booting;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public void setRollbackOnly() {
        this.resultAction = OperationContext.ResultAction.ROLLBACK;
    }

    private boolean isRollingBack() {
        return this.currentStage == OperationContext.Stage.DONE && this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public void reloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.restartStampHolder.restartStamp = this.processState.setReloadRequired();
            this.response.get(new String[]{"response-headers", "operation-requires-reload"}).set(true);
        } else {
            this.restartRequired();
        }
    }

    @Override
    public void restartRequired() {
        this.restartStampHolder.restartStamp = this.processState.setRestartRequired();
        this.response.get(new String[]{"response-headers", "operation-requires-restart"}).set(true);
    }

    @Override
    public void revertReloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.processState.revertReloadRequired(this.restartStampHolder.restartStamp);
            if (this.response.get("response-headers").hasDefined("operation-requires-reload")) {
                this.response.get("response-headers").remove("operation-requires-reload");
                if (this.response.get("response-headers").asInt() == 0) {
                    this.response.remove("response-headers");
                }
            }
        } else {
            this.revertRestartRequired();
        }
    }

    @Override
    public void revertRestartRequired() {
        this.processState.revertRestartRequired(this.restartStampHolder.restartStamp);
        if (this.response.get("response-headers").hasDefined("operation-requires-restart")) {
            this.response.get("response-headers").remove("operation-requires-restart");
            if (this.response.get("response-headers").asInt() == 0) {
                this.response.remove("response-headers");
            }
        }
    }

    @Override
    public void runtimeUpdateSkipped() {
        this.response.get(new String[]{"response-headers", "runtime-update-skipped"}).set(true);
    }

    @Override
    public ManagementResourceRegistration getResourceRegistrationForUpdate() {
        PathAddress address = this.modelAddress;
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw new IllegalStateException("Stage MODEL is already complete");
        }
        if (!this.affectsResourceRegistration) {
            this.takeWriteLock();
            this.affectsResourceRegistration = true;
        }
        return this.modelController.getRootRegistration().getSubModel(address);
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration() {
        PathAddress address = this.modelAddress;
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null || currentStage == OperationContext.Stage.DONE) {
            throw new IllegalStateException("Operation already complete");
        }
        ManagementResourceRegistration delegate = this.modelController.getRootRegistration().getSubModel(address);
        return delegate == null ? null : new DelegatingImmutableManagementResourceRegistration(delegate);
    }

    @Override
    public ServiceRegistry getServiceRegistry(boolean modify) throws UnsupportedOperationException {
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && (!this.isRollingBack() || modify)) {
            throw new IllegalStateException("Get service registry only supported in runtime operations");
        }
        if (modify && !this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            this.acquireContainerMonitor();
            this.awaitContainerMonitor();
        }
        return this.modelController.getServiceRegistry();
    }

    @Override
    public ServiceController<?> removeService(ServiceName name) throws UnsupportedOperationException {
        ServiceController controller;
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw new IllegalStateException("Service removal only supported in runtime operations");
        }
        if (!this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            this.acquireContainerMonitor();
            this.awaitContainerMonitor();
        }
        if ((controller = this.modelController.getServiceRegistry().getService(name)) != null) {
            this.doRemove(controller);
        }
        return controller;
    }

    @Override
    public void removeService(ServiceController<?> controller) throws UnsupportedOperationException {
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw new IllegalStateException("Service removal only supported in runtime operations");
        }
        if (!this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            this.acquireContainerMonitor();
            this.awaitContainerMonitor();
        }
        this.doRemove(controller);
    }

    private void doRemove(ServiceController<?> controller) {
        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void listenerAdded(ServiceController<?> controller) {
                Map map;
                Map map2 = map = OperationContextImpl.this.realRemovingControllers;
                synchronized (map2) {
                    map.put(controller.getName(), controller);
                    controller.setMode(ServiceController.Mode.REMOVE);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case REMOVING_to_REMOVED: 
                    case REMOVING_to_DOWN: {
                        Map map;
                        Map map2 = map = OperationContextImpl.this.realRemovingControllers;
                        synchronized (map2) {
                            if (map.get(controller.getName()) == controller) {
                                map.remove(controller.getName());
                                map.notifyAll();
                            }
                            break;
                        }
                    }
                }
            }
        });
    }

    @Override
    public ServiceTarget getServiceTarget() throws UnsupportedOperationException {
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.RUNTIME && currentStage != OperationContext.Stage.VERIFY && !this.isRollingBack()) {
            throw new IllegalStateException("Get service target only supported in runtime operations");
        }
        if (!this.affectsRuntime) {
            this.takeWriteLock();
            this.affectsRuntime = true;
            this.acquireContainerMonitor();
            this.awaitContainerMonitor();
        }
        return this.serviceTarget;
    }

    private void takeWriteLock() {
        if (this.lockDepth == 0) {
            if (this.currentStage == OperationContext.Stage.DONE) {
                throw new IllegalStateException("Invalid modification after completed step");
            }
            try {
                this.modelController.acquireLock(this.respectInterruption);
                this.lockDepth = this.depth;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CancellationException("Operation cancelled asynchronously");
            }
        }
    }

    private void acquireContainerMonitor() {
        if (this.containerMonitorDepth == 0) {
            if (this.currentStage == OperationContext.Stage.DONE) {
                throw new IllegalStateException("Invalid modification after completed step");
            }
            this.modelController.acquireContainerMonitor();
            this.containerMonitorDepth = this.depth;
        }
    }

    private void awaitContainerMonitor() {
        try {
            this.modelController.awaitContainerMonitor(this.respectInterruption, 1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException("Operation cancelled asynchronously");
        }
    }

    @Override
    public ModelNode readModel(PathAddress requestAddress) {
        PathAddress address = this.modelAddress.append(requestAddress);
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        Resource model = this.model;
        for (PathElement element : address) {
            model = model.requireChild(element);
        }
        return Resource.Tools.readModel(model);
    }

    @Override
    public ModelNode readModelForUpdate(PathAddress requestAddress) {
        PathAddress address = this.modelAddress.append(requestAddress);
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw new IllegalStateException("Stage MODEL is already complete");
        }
        if (this.affectsModel.size() == 0) {
            this.takeWriteLock();
            this.model = this.model.clone();
        }
        this.affectsModel.add(address);
        Resource model = this.model;
        Iterator i = address.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw new IllegalArgumentException("Cannot write to *");
            }
            if (!i.hasNext()) {
                String key = element.getKey();
                if (!model.hasChild(element)) {
                    PathAddress parent = address.subAddress(0, address.size() - 1);
                    Set<String> childrenNames = this.modelController.getRootRegistration().getChildNames(parent);
                    if (!childrenNames.contains(key)) {
                        throw new IllegalStateException("no child-type " + key);
                    }
                    Resource newModel = Resource.Factory.create();
                    model.registerChild(element, newModel);
                    model = newModel;
                    continue;
                }
                model = model.requireChild(element);
                continue;
            }
            model = model.requireChild(element);
        }
        if (model == null) {
            throw new IllegalStateException();
        }
        return model.getModel();
    }

    @Override
    public Resource readResource(PathAddress requestAddress) {
        PathAddress address = this.modelAddress.append(requestAddress);
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        Resource model = this.model;
        for (PathElement element : address) {
            model = model.requireChild(element);
        }
        return model.clone();
    }

    @Override
    public Resource readResourceForUpdate(PathAddress requestAddress) {
        PathAddress address = this.modelAddress.append(requestAddress);
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw new IllegalStateException("Stage MODEL is already complete");
        }
        if (this.affectsModel.size() == 0) {
            this.takeWriteLock();
            this.model = this.model.clone();
        }
        this.affectsModel.add(address);
        Resource resource = this.model;
        for (PathElement element : address) {
            if (element.isMultiTarget()) {
                throw new IllegalArgumentException("Cannot write to *");
            }
            resource = resource.requireChild(element);
        }
        return resource;
    }

    @Override
    public Resource createResource(PathAddress relativeAddress) {
        Resource toAdd = Resource.Factory.create();
        this.addResource(relativeAddress, toAdd);
        return toAdd;
    }

    @Override
    public void addResource(PathAddress relativeAddress, Resource toAdd) {
        PathAddress absoluteAddress = this.modelAddress.append(relativeAddress);
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw new IllegalStateException("Stage MODEL is already complete");
        }
        if (absoluteAddress.size() == 0) {
            throw new IllegalStateException("Duplicate resource " + absoluteAddress);
        }
        if (this.affectsModel.size() == 0) {
            this.takeWriteLock();
            this.model = this.model.clone();
        }
        this.affectsModel.add(absoluteAddress);
        Resource model = this.model;
        Iterator i = absoluteAddress.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw new IllegalArgumentException("Cannot write to *");
            }
            if (!i.hasNext()) {
                String key = element.getKey();
                if (model.hasChild(element)) {
                    throw new IllegalStateException("Duplicate resource " + absoluteAddress);
                }
                PathAddress parent = absoluteAddress.subAddress(0, absoluteAddress.size() - 1);
                Set<String> childrenNames = this.modelController.getRootRegistration().getChildNames(parent);
                if (!childrenNames.contains(key)) {
                    throw new IllegalStateException("no child-type " + key);
                }
                model.registerChild(element, toAdd);
                model = toAdd;
                continue;
            }
            model = model.requireChild(element);
        }
    }

    @Override
    public Resource removeResource(PathAddress requestAddress) {
        PathAddress address = this.modelAddress.append(requestAddress);
        assert (Thread.currentThread() == this.initiatingThread);
        OperationContext.Stage currentStage = this.currentStage;
        if (currentStage == null) {
            throw new IllegalStateException("Operation already complete");
        }
        if (currentStage != OperationContext.Stage.MODEL) {
            throw new IllegalStateException("Stage MODEL is already complete");
        }
        if (this.affectsModel.size() == 0) {
            this.takeWriteLock();
            this.model = this.model.clone();
        }
        this.affectsModel.add(address);
        Resource model = this.model;
        Iterator i = address.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw new IllegalArgumentException("Cannot remove *");
            }
            if (!i.hasNext()) {
                model = model.removeChild(element);
                continue;
            }
            model = model.requireChild(element);
        }
        return model;
    }

    @Override
    public void acquireControllerLock() {
        this.takeWriteLock();
    }

    @Override
    public Resource getRootResource() {
        Resource readOnlyModel = this.model;
        return readOnlyModel.clone();
    }

    @Override
    public boolean isModelAffected() {
        return this.affectsModel.size() > 0;
    }

    @Override
    public boolean isRuntimeAffected() {
        return this.affectsRuntime;
    }

    @Override
    public boolean isResourceRegistryAffected() {
        return this.affectsResourceRegistration;
    }

    @Override
    public OperationContext.Stage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void report(MessageSeverity severity, String message) {
        try {
            this.messageHandler.handleReport(severity, message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public ModelNode getResult() {
        return this.response.get("result");
    }

    @Override
    public boolean hasResult() {
        return this.response.has("result");
    }

    class ContextServiceBuilder<T>
    implements ServiceBuilder<T> {
        private final ServiceBuilder<T> realBuilder;
        private final ServiceName name;

        ContextServiceBuilder(ServiceBuilder<T> realBuilder, ServiceName name) {
            this.realBuilder = realBuilder;
            this.name = name;
        }

        public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
            this.realBuilder.addAliases(aliases);
            return this;
        }

        public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
            this.realBuilder.setInitialMode(mode);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceName ... dependencies) {
            this.realBuilder.addDependencies(dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... dependencies) {
            this.realBuilder.addDependencies(dependencyType, dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(Iterable<ServiceName> dependencies) {
            this.realBuilder.addDependencies(dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> dependencies) {
            this.realBuilder.addDependencies(dependencyType, dependencies);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceName dependency) {
            this.realBuilder.addDependency(dependency);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
            this.realBuilder.addDependency(dependencyType, dependency);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
            this.realBuilder.addDependency(dependency, target);
            return this;
        }

        public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
            this.realBuilder.addDependency(dependencyType, dependency, target);
            return this;
        }

        public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
            this.realBuilder.addDependency(dependency, type, target);
            return this;
        }

        public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
            this.realBuilder.addDependency(dependencyType, dependency, type, target);
            return this;
        }

        public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
            this.realBuilder.addInjection(target, value);
            return this;
        }

        public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
            this.realBuilder.addInjectionValue(target, value);
            return this;
        }

        public ServiceBuilder<T> addInjection(Injector<? super T> target) {
            this.realBuilder.addInjection(target);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
            this.realBuilder.addListener(listener);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
            this.realBuilder.addListener(listeners);
            return this;
        }

        public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
            this.realBuilder.addListener(listeners);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, ServiceListener<? super T> listener) {
            this.realBuilder.addListener(inheritance, listener);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, ServiceListener<? super T> ... listeners) {
            this.realBuilder.addListener(inheritance, listeners);
            return this;
        }

        public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, Collection<? extends ServiceListener<? super T>> listeners) {
            this.realBuilder.addListener(inheritance, listeners);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public ServiceController<T> install() throws ServiceRegistryException, IllegalStateException {
            Map map;
            Map map2 = map = OperationContextImpl.this.realRemovingControllers;
            synchronized (map2) {
                block15: {
                    while (map.containsKey(this.name)) {
                        try {
                            map.wait();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            throw new CancellationException("Service install was cancelled");
                        }
                    }
                    boolean intr = false;
                    while (true) {
                        ServiceController serviceController;
                        if (!map.containsKey(this.name)) break block15;
                        try {
                            map.wait();
                            serviceController = this.realBuilder.install();
                        }
                        catch (InterruptedException e) {
                            if (OperationContextImpl.this.respectInterruption) {
                                Thread.currentThread().interrupt();
                                throw new CancellationException("Service install was cancelled");
                            }
                            intr = true;
                            continue;
                        }
                        return serviceController;
                    }
                    finally {
                        if (intr) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                return this.realBuilder.install();
            }
        }
    }

    class ContextServiceTarget
    implements ServiceTarget {
        private final ModelControllerImpl modelController;

        ContextServiceTarget(ModelControllerImpl modelController) {
            this.modelController = modelController;
        }

        public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) {
            ServiceBuilder realBuilder = this.modelController.getServiceTarget().addServiceValue(name, value);
            return new ContextServiceBuilder(realBuilder, name);
        }

        public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) {
            return this.addServiceValue(name, (Value<? extends Service<T>>)new ImmediateValue(service));
        }

        public ServiceTarget addListener(ServiceListener<Object> listener) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener<Object> ... listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(Collection<ServiceListener<Object>> listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener.Inheritance inheritance, ServiceListener<Object> listener) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener.Inheritance inheritance, ServiceListener<Object> ... listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addListener(ServiceListener.Inheritance inheritance, Collection<ServiceListener<Object>> listeners) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget removeListener(ServiceListener<Object> listener) {
            throw new UnsupportedOperationException();
        }

        public Set<ServiceListener<Object>> getListeners() {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(ServiceName dependency) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(ServiceName ... dependencies) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget addDependency(Collection<ServiceName> dependencies) {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget removeDependency(ServiceName dependency) {
            throw new UnsupportedOperationException();
        }

        public Set<ServiceName> getDependencies() {
            throw new UnsupportedOperationException();
        }

        public ServiceTarget subTarget() {
            throw new UnsupportedOperationException();
        }

        public BatchServiceTarget batchTarget() {
            throw new UnsupportedOperationException();
        }
    }

    static class StampHolder {
        private Object restartStamp;

        StampHolder() {
        }
    }

    static class Step {
        private final OperationStepHandler handler;
        private final ModelNode response;
        private final ModelNode operation;
        private final StampHolder restartStamp = new StampHolder();

        private Step(OperationStepHandler handler, ModelNode response, ModelNode operation) {
            this.handler = handler;
            this.response = response;
            this.operation = operation;
            response.get("outcome");
        }
    }

    static enum ContextFlag {
        ROLLBACK_ON_FAIL;

    }
}

