/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SimpleAttributeDefinition
extends AttributeDefinition {
    public SimpleAttributeDefinition(String name, ModelType type, boolean allowNull) {
        this(name, name, null, type, allowNull, false, null);
    }

    public SimpleAttributeDefinition(String name, ModelType type, boolean allowNull, MeasurementUnit measurementUnit) {
        this(name, name, null, type, allowNull, false, measurementUnit);
    }

    public SimpleAttributeDefinition(String name, ModelNode defaultValue, ModelType type, boolean allowNull) {
        this(name, name, defaultValue, type, allowNull, false, null);
    }

    public SimpleAttributeDefinition(String name, ModelNode defaultValue, ModelType type, boolean allowNull, MeasurementUnit measurementUnit) {
        this(name, name, defaultValue, type, allowNull, false, measurementUnit);
    }

    public SimpleAttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit) {
        this(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, SimpleAttributeDefinition.createParameterValidator(type, allowNull, allowExpression), null);
    }

    public SimpleAttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterValidator validator) {
        this(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, validator, null);
    }

    public SimpleAttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterValidator validator, String[] alternatives) {
        super(name, xmlName, defaultValue, type, allowNull, allowExpression, measurementUnit, validator, alternatives);
    }

    public SimpleAttributeDefinition(String name, ModelNode defaultValue, ModelType type, boolean allowNull, String[] alternatives) {
        this(name, name, defaultValue, type, allowNull, false, MeasurementUnit.NONE, SimpleAttributeDefinition.createParameterValidator(type, allowNull, false), alternatives);
    }

    private static ParameterValidator createParameterValidator(ModelType type, boolean allowNull, boolean allowExpression) {
        if (type == ModelType.STRING) {
            return new StringLengthValidator(1, Integer.MAX_VALUE, allowNull, allowExpression);
        }
        return new ModelTypeValidator(type, allowNull, allowExpression);
    }

    public ModelNode parse(String value, Location location) throws XMLStreamException {
        ModelNode node;
        String trimmed;
        String string = trimmed = value == null ? null : value.trim();
        if (trimmed != null) {
            node = this.isAllowExpression() ? ParseUtils.parsePossibleExpression(trimmed) : new ModelNode().set(trimmed);
            if (node.getType() != ModelType.EXPRESSION) {
                switch (this.getType()) {
                    case BIG_DECIMAL: {
                        node.set(node.asBigDecimal());
                        break;
                    }
                    case BIG_INTEGER: {
                        node.set(node.asBigInteger());
                        break;
                    }
                    case BOOLEAN: {
                        node.set(node.asBoolean());
                        break;
                    }
                    case BYTES: {
                        node.set(node.asBytes());
                        break;
                    }
                    case DOUBLE: {
                        node.set(node.asDouble());
                        break;
                    }
                    case INT: {
                        node.set(node.asInt());
                        break;
                    }
                    case LONG: {
                        node.set(node.asLong());
                    }
                }
            }
        } else {
            node = this.getDefaultValue().isDefined() ? new ModelNode().set(this.getDefaultValue()) : new ModelNode();
        }
        try {
            this.getValidator().validateParameter(this.getXmlName(), node);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), location);
        }
        return node;
    }

    public void parseAndSetParameter(String value, ModelNode operation, Location location) throws XMLStreamException {
        ModelNode paramVal = this.parse(value, location);
        operation.get(this.getName()).set(paramVal);
    }

    public void marshallAsAttribute(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        this.marshallAsAttribute(resourceModel, true, writer);
    }

    public void marshallAsAttribute(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (this.isMarshallable(resourceModel, marshallDefault)) {
            writer.writeAttribute(this.getXmlName(), resourceModel.get(this.getName()).asString());
        }
    }

    @Override
    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        this.marshallAsElement(resourceModel, true, writer);
    }

    public void marshallAsElement(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (this.isMarshallable(resourceModel, marshallDefault)) {
            writer.writeStartElement(this.getXmlName());
            writer.writeCharacters(resourceModel.get(this.getName()).asString());
            writer.writeEndElement();
        }
    }
}

