/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.PathDescription;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalDescriptions {
    private static final String RESOURCE_NAME = PathDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getReadResourceOperationDescription(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-resource");
        node.get("description").set(bundle.getString("global.read-resource"));
        node.get(new String[]{"request-properties", "recursive", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "recursive", "description"}).set(bundle.getString("global.read-resource.recursive"));
        node.get(new String[]{"request-properties", "recursive", "required"}).set(false);
        node.get(new String[]{"request-properties", "recursive", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "recursive", "default"}).set(false);
        node.get(new String[]{"request-properties", "proxies", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "proxies", "description"}).set(bundle.getString("global.read-resource.proxies"));
        node.get(new String[]{"request-properties", "proxies", "required"}).set(false);
        node.get(new String[]{"request-properties", "proxies", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "proxies", "default"}).set(false);
        node.get(new String[]{"request-properties", "include-runtime", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "include-runtime", "description"}).set(bundle.getString("global.read-resource.include-runtime"));
        node.get(new String[]{"request-properties", "include-runtime", "required"}).set(false);
        node.get(new String[]{"request-properties", "include-runtime", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "include-runtime", "default"}).set(false);
        node.get(new String[]{"request-properties", "include-defaults", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "include-defaults", "description"}).set(bundle.getString("global.read-resource.include-defaults"));
        node.get(new String[]{"request-properties", "include-defaults", "required"}).set(false);
        node.get(new String[]{"request-properties", "include-defaults", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "include-defaults", "default"}).set(true);
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("global.read-resource.reply"));
        return node;
    }

    public static ModelNode getReadAttributeOperationDescription(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-attribute");
        node.get("description").set(bundle.getString("global.read-attribute"));
        node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("global.read-attribute.name"));
        node.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        node.get(new String[]{"request-properties", "include-defaults", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "include-defaults", "description"}).set(bundle.getString("global.read-attribute.include-defaults"));
        node.get(new String[]{"request-properties", "include-defaults", "required"}).set(false);
        node.get(new String[]{"request-properties", "include-defaults", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "include-defaults", "default"}).set(true);
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"reply-properties", "value-type"}).set(bundle.getString("global.read-attribute.reply.type"));
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("global.read-attribute.reply"));
        return node;
    }

    public static ModelNode getWriteAttributeOperationDescription(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("write-attribute");
        node.get("description").set(bundle.getString("global.write-attribute"));
        node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("global.write-attribute.name"));
        node.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        node.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "value", "description"}).set(bundle.getString("global.write-attribute.value"));
        node.get(new String[]{"request-properties", "value", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "value", "required"}).set(false);
        return node;
    }

    public static ModelNode getReadChildrenNamesOperationDescription(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-children-names");
        node.get("description").set(bundle.getString("global.read-children-names"));
        node.get(new String[]{"request-properties", "child-type", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "child-type", "description"}).set(bundle.getString("global.read-children-names.child-type"));
        node.get(new String[]{"request-properties", "child-type", "nillable"}).set(false);
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("global.read-children-names.reply"));
        node.get(new String[]{"reply-properties", "value-type"}).set(ModelType.STRING);
        return node;
    }

    public static ModelNode getReadChildrenTypesOperationDescription(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-children-types");
        node.get("description").set(bundle.getString("global.read-children-types"));
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("global.read-children-types.reply"));
        node.get(new String[]{"reply-properties", "value-type"}).set(ModelType.STRING);
        return node;
    }

    public static ModelNode getReadChildrenResourcesOperationDescription(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-children-resources");
        node.get("description").set(bundle.getString("global.read-children-resources"));
        node.get(new String[]{"request-properties", "child-type", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "child-type", "description"}).set(bundle.getString("global.read-children-resources.child-type"));
        node.get(new String[]{"request-properties", "child-type", "nillable"}).set(false);
        node.get(new String[]{"request-properties", "recursive", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "recursive", "description"}).set(bundle.getString("global.read-children-resources.recursive"));
        node.get(new String[]{"request-properties", "recursive", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "proxies", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "proxies", "description"}).set(bundle.getString("global.read-children-resources.proxies"));
        node.get(new String[]{"request-properties", "proxies", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "include-runtime", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "include-runtime", "description"}).set(bundle.getString("global.read-children-resources.include-runtime"));
        node.get(new String[]{"request-properties", "include-runtime", "required"}).set(false);
        node.get(new String[]{"request-properties", "include-runtime", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "include-defaults", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "include-defaults", "description"}).set(bundle.getString("global.read-children-resources.include-defaults"));
        node.get(new String[]{"request-properties", "include-defaults", "required"}).set(false);
        node.get(new String[]{"request-properties", "include-defaults", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "include-defaults", "default"}).set(true);
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("global.read-children-resources.reply"));
        node.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return node;
    }

    public static ModelNode getReadOperationNamesOperation(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-operation-names");
        node.get("description").set(bundle.getString("global.read-operation-names"));
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        node.get(new String[]{"reply-properties", "value-type"}).set(ModelType.STRING);
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("global.read-operation-names.reply"));
        return node;
    }

    public static ModelNode getReadOperationOperation(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-operation-description");
        node.get("description").set(bundle.getString("global.read-operation"));
        node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("global.read-operation.type"));
        node.get(new String[]{"request-properties", "name", "required"}).set(true);
        node.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        node.get(new String[]{"request-properties", "locale", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "name", "required"}).set(false);
        node.get(new String[]{"request-properties", "locale", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "locale", "description"}).set(bundle.getString("global.read-operation.locale"));
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("global.read-operation.type"));
        return node;
    }

    public static ModelNode getReadResourceDescriptionOperationDescription(Locale locale) {
        ResourceBundle bundle = GlobalDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-resource-description");
        node.get("description").set(bundle.getString("global.read-resource-description"));
        node.get(new String[]{"request-properties", "operations", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "operations", "description"}).set(bundle.getString("global.read-resource-description.operations"));
        node.get(new String[]{"request-properties", "operations", "required"}).set(false);
        node.get(new String[]{"request-properties", "operations", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "inherited", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "inherited", "description"}).set(bundle.getString("global.read-resource-description.inherited"));
        node.get(new String[]{"request-properties", "recursive", "required"}).set(false);
        node.get(new String[]{"request-properties", "inherited", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "recursive", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "recursive", "description"}).set(bundle.getString("global.read-resource-description.recursive"));
        node.get(new String[]{"request-properties", "recursive", "required"}).set(false);
        node.get(new String[]{"request-properties", "recursive", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "locale", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "locale", "required"}).set(false);
        node.get(new String[]{"request-properties", "locale", "nillable"}).set(true);
        node.get(new String[]{"request-properties", "locale", "description"}).set(bundle.getString("global.read-resource-description.locale"));
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("global.read-resource-description.reply"));
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

