/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.CommonXml;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class HostXml
extends CommonXml {
    public HostXml(ModuleLoader loader) {
        super(loader);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operationList) throws XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
        if (readerNS != Namespace.DOMAIN_1_0 && readerNS != Namespace.DOMAIN_1_1) {
            throw ParseUtils.unexpectedElement(reader);
        }
        if (Element.forName(reader.getLocalName()) != Element.HOST) {
            throw ParseUtils.unexpectedElement(reader);
        }
        this.readHostElement(reader, address, operationList);
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode modelNode = context.getModelNode();
        writer.writeStartDocument();
        writer.writeStartElement(Element.HOST.getLocalName());
        if (modelNode.hasDefined("name")) {
            HostXml.writeAttribute(writer, Attribute.NAME, modelNode.get("name").asString());
        }
        writer.writeDefaultNamespace(Namespace.CURRENT.getUriString());
        this.writeNamespaces(writer, modelNode);
        this.writeSchemaLocation(writer, modelNode);
        if (modelNode.hasDefined("system-property")) {
            this.writeProperties(writer, modelNode.get("system-property"), Element.SYSTEM_PROPERTIES, false);
        }
        if (modelNode.hasDefined("path")) {
            this.writePaths(writer, modelNode.get("path"));
        }
        if (modelNode.hasDefined("core-service") && modelNode.get("core-service").hasDefined("vault")) {
            this.writeVault(writer, modelNode.get(new String[]{"core-service", "vault"}));
        }
        if (modelNode.hasDefined("vault")) {
            ModelNode vault = modelNode.get("vault");
            writer.writeStartElement(Element.VAULT.getLocalName());
            String code = vault.get(Attribute.CODE.getLocalName()).asString();
            if (code != null && !code.isEmpty() && !code.equals("undefined")) {
                writer.writeAttribute(Attribute.CODE.getLocalName(), code);
            }
            ModelNode addNode = vault.get("add");
            ModelNode properties = addNode.get("vault-option");
            for (Property prop : properties.asPropertyList()) {
                writer.writeEmptyElement(Element.VAULT_OPTION.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
            }
            writer.writeEndElement();
        }
        if (modelNode.hasDefined("core-service") && modelNode.get("core-service").hasDefined("management")) {
            this.writeManagement(writer, modelNode.get(new String[]{"core-service", "management"}), true);
        }
        if (modelNode.hasDefined("domain-controller")) {
            this.writeDomainController(writer, modelNode.get("domain-controller"));
        }
        if (modelNode.hasDefined("interface")) {
            this.writeInterfaces(writer, modelNode.get("interface"));
        }
        if (modelNode.hasDefined("jvm")) {
            writer.writeStartElement(Element.JVMS.getLocalName());
            for (Property jvm : modelNode.get("jvm").asPropertyList()) {
                this.writeJVMElement(writer, jvm.getName(), jvm.getValue());
            }
            writer.writeEndElement();
        }
        if (modelNode.hasDefined("server-config")) {
            this.writeServers(writer, modelNode.get("server-config"));
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void readHostElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String hostName = null;
        LinkedList<ModelNode> namespaceOperations = new LinkedList<ModelNode>();
        this.parseNamespaces(reader, address, namespaceOperations);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri(reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            hostName = value;
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName(reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, namespaceOperations, i);
                            continue block11;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (hostName == null) {
            hostName = this.getDefaultName();
        }
        this.addLocalHost(address, list, hostName);
        for (ModelNode operation : namespaceOperations) {
            operation.get("address").set(address);
            list.add(operation);
        }
        Element element = ParseUtils.nextElement(reader);
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, list, false);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.VAULT) {
            Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
            if (schemaVer == Namespace.DOMAIN_1_0) {
                throw ParseUtils.unexpectedElement(reader);
            }
            this.parseVault(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.MANAGEMENT) {
            this.parseManagement(reader, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.DOMAIN_CONTROLLER) {
            this.parseDomainController(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.JVMS) {
            this.parseJvms(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.SERVERS) {
            this.parseServers(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
    }

    private void addLocalHost(ModelNode address, List<ModelNode> operationList, String hostName) {
        address.add("host", hostName);
        ModelNode host = new ModelNode();
        host.get("operation").set("add-host");
        host.get("address").set(address.clone());
        host.get("name").set(hostName);
        operationList.add(host);
    }

    private void parseDomainController(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        boolean hasLocal = false;
        boolean hasRemote = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOCAL: {
                    if (hasLocal) {
                        throw new XMLStreamException("Child " + element.getLocalName() + " of element " + Element.DOMAIN_CONTROLLER.getLocalName() + " already declared", reader.getLocation());
                    }
                    if (hasRemote) {
                        throw new XMLStreamException("Child " + Element.REMOTE.getLocalName() + " of element " + Element.DOMAIN_CONTROLLER.getLocalName() + " already declared", reader.getLocation());
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    hasLocal = true;
                    continue block4;
                }
                case REMOTE: {
                    if (hasRemote) {
                        throw new XMLStreamException("Child " + element.getLocalName() + " of element " + Element.DOMAIN_CONTROLLER.getLocalName() + " already declared", reader.getLocation());
                    }
                    if (hasLocal) {
                        throw new XMLStreamException("Child " + Element.LOCAL.getLocalName() + " of element " + Element.DOMAIN_CONTROLLER.getLocalName() + " already declared", reader.getLocation());
                    }
                    this.parseRemoteDomainController(reader, address, list);
                    hasRemote = true;
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!hasLocal && !hasRemote) {
            throw new XMLStreamException("Either a " + Element.REMOTE.getLocalName() + " or " + Element.LOCAL.getLocalName() + " domain controller configuration must be declared.", reader.getLocation());
        }
        if (hasLocal) {
            ModelNode update = new ModelNode();
            update.get("address").set(address);
            update.get("operation").set("write-local-domain-controller");
            list.add(update);
        }
    }

    private void parseRemoteDomainController(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String host = null;
        Integer port = null;
        String securityRealm = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    host = value;
                    continue block5;
                }
                case PORT: {
                    port = Integer.valueOf(value);
                    if (port >= 1) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + port + " -- cannot be less than one", reader.getLocation());
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (host == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.HOST.getLocalName()));
        }
        if (port == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PORT.getLocalName()));
        }
        ModelNode update = new ModelNode();
        update.get("address").set(address);
        update.get("operation").set("write-remote-domain-controller");
        update.get("host").set(ParseUtils.parsePossibleExpression(host));
        update.get("port").set(port.intValue());
        if (securityRealm != null) {
            update.get("security-realm").set(securityRealm);
        }
        list.add(update);
        reader.discardRemainder();
    }

    private void parseJvms(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JVM: {
                    this.parseJvm(reader, address, list, names);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseServers(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVER: {
                    this.parseServer(reader, address, list, names);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseServer(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, Set<String> serverNames) throws XMLStreamException {
        String name = null;
        String group = null;
        Boolean start = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (!serverNames.add(value)) {
                        throw new XMLStreamException("Duplicate server declaration " + value, reader.getLocation());
                    }
                    name = value;
                    continue block12;
                }
                case GROUP: {
                    group = value;
                    continue block12;
                }
                case AUTO_START: {
                    start = Boolean.valueOf(value);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (group == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.GROUP));
        }
        ModelNode address = parentAddress.clone().add("server-config", name);
        ModelNode addUpdate = Util.getEmptyOperation("add", address);
        addUpdate.get("group").set(group);
        if (start != null) {
            addUpdate.get("auto-start").set(start.booleanValue());
        }
        list.add(addUpdate);
        boolean sawJvm = false;
        boolean sawSystemProperties = false;
        boolean sawSocketBinding = false;
        HashSet<String> interfaceNames = new HashSet<String>();
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACE_SPECS: {
                    this.parseInterfaces(reader, interfaceNames, address, list, true);
                    continue block13;
                }
                case JVM: {
                    if (sawJvm) {
                        throw new XMLStreamException(element.getLocalName() + " already defined", reader.getLocation());
                    }
                    this.parseJvm(reader, address, list, new HashSet<String>());
                    sawJvm = true;
                    continue block13;
                }
                case PATHS: {
                    this.parsePaths(reader, address, list, true);
                    continue block13;
                }
                case SOCKET_BINDING_GROUP: {
                    if (sawSocketBinding) {
                        throw new XMLStreamException(element.getLocalName() + " already defined", reader.getLocation());
                    }
                    this.parseSocketBindingGroupRef(reader, address, list);
                    sawSocketBinding = true;
                    continue block13;
                }
                case SYSTEM_PROPERTIES: {
                    if (sawSystemProperties) {
                        throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                    }
                    this.parseSystemProperties(reader, address, list, false);
                    sawSystemProperties = true;
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void writeDomainController(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        writer.writeStartElement(Element.DOMAIN_CONTROLLER.getLocalName());
        if (modelNode.hasDefined("local")) {
            writer.writeEmptyElement(Element.LOCAL.getLocalName());
        } else if (modelNode.hasDefined("remote")) {
            writer.writeStartElement(Element.REMOTE.getLocalName());
            ModelNode remote = modelNode.get("remote");
            if (remote.has("host")) {
                HostXml.writeAttribute(writer, Attribute.HOST, remote.get("host").asString());
            }
            if (remote.has("port")) {
                HostXml.writeAttribute(writer, Attribute.PORT, remote.get("port").asString());
            }
            if (remote.hasDefined("security-realm")) {
                HostXml.writeAttribute(writer, Attribute.SECURITY_REALM, remote.require("security-realm").asString());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeServers(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        writer.writeStartElement(Element.SERVERS.getLocalName());
        for (Property prop : modelNode.asPropertyList()) {
            Iterator i$;
            ModelNode server = prop.getValue();
            writer.writeStartElement(Element.SERVER.getLocalName());
            HostXml.writeAttribute(writer, Attribute.NAME, prop.getName());
            if (server.hasDefined("group")) {
                HostXml.writeAttribute(writer, Attribute.GROUP, server.get("group").asString());
            }
            if (server.hasDefined("auto-start")) {
                HostXml.writeAttribute(writer, Attribute.AUTO_START, server.get("auto-start").asString());
            }
            if (server.hasDefined("path")) {
                this.writePaths(writer, server.get("path"));
            }
            if (server.hasDefined("system-property")) {
                this.writeProperties(writer, server.get("system-property"), Element.SYSTEM_PROPERTIES, false);
            }
            if (server.hasDefined("interface")) {
                this.writeInterfaces(writer, server.get("interface"));
            }
            if (server.hasDefined("jvm") && (i$ = server.get("jvm").asPropertyList().iterator()).hasNext()) {
                Property jvm = (Property)i$.next();
                this.writeJVMElement(writer, jvm.getName(), jvm.getValue());
            }
            if (server.hasDefined("socket-binding-group")) {
                writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
                HostXml.writeAttribute(writer, Attribute.REF, server.get("socket-binding-group").asString());
                if (server.hasDefined("socket-binding-port-offset") && server.get("socket-binding-port-offset").asInt() > 0) {
                    HostXml.writeAttribute(writer, Attribute.PORT_OFFSET, server.get("socket-binding-port-offset").asString());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

