/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class ParseUtils {
    private ParseUtils() {
    }

    public static Element nextElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return null;
        }
        Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
        if (readerNS != Namespace.DOMAIN_1_0 && readerNS != Namespace.DOMAIN_1_1) {
            throw ParseUtils.unexpectedElement(reader);
        }
        return Element.forName(reader.getLocalName());
    }

    public static XMLStreamException unexpectedElement(XMLExtendedStreamReader reader) {
        return new XMLStreamException("Unexpected element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    public static XMLStreamException unexpectedEndElement(XMLExtendedStreamReader reader) {
        return new XMLStreamException("Unexpected end of element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    public static XMLStreamException unexpectedAttribute(XMLExtendedStreamReader reader, int index) {
        return new XMLStreamException("Unexpected attribute '" + reader.getAttributeName(index) + "' encountered", reader.getLocation());
    }

    public static XMLStreamException invalidAttributeValue(XMLExtendedStreamReader reader, int index) {
        return new XMLStreamException("Invalid value '" + reader.getAttributeValue(index) + "' for attribute '" + reader.getAttributeName(index) + "'", reader.getLocation());
    }

    public static XMLStreamException missingRequired(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required attribute(s): " + b, reader.getLocation());
    }

    public static XMLStreamException missingRequiredElement(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required element(s): " + b, reader.getLocation());
    }

    public static void requireNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
    }

    public static void requireNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static XMLStreamException duplicateAttribute(XMLExtendedStreamReader reader, String name) {
        return new XMLStreamException("An attribute named '" + name + "' has already been declared", reader.getLocation());
    }

    public static XMLStreamException duplicateNamedElement(XMLExtendedStreamReader reader, String name) {
        return new XMLStreamException("An element of this type named '" + name + "' has already been declared", reader.getLocation());
    }

    public static boolean readBooleanAttributeElement(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        boolean value = Boolean.parseBoolean(reader.getAttributeValue(0));
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static String readStringAttributeElement(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        String value = reader.getAttributeValue(0);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static <T> List<T> readListAttributeElement(XMLExtendedStreamReader reader, String attributeName, Class<T> type) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        List value = reader.getListAttributeValue(0, type);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static Property readProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        int cnt = reader.getAttributeCount();
        String name = null;
        String value = null;
        for (int i = 0; i < cnt; ++i) {
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            String localName = reader.getAttributeLocalName(i);
            if (localName.equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (localName.equals("value")) {
                value = reader.getAttributeValue(i);
                continue;
            }
            throw ParseUtils.unexpectedAttribute(reader, i);
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton("name"));
        }
        return new Property(name, new ModelNode().set(value == null ? "" : value));
    }

    public static <T> T[] readArrayAttributeElement(XMLExtendedStreamReader reader, String attributeName, Class<T> type) throws XMLStreamException {
        List<Object> list = ParseUtils.readListAttributeElement(reader, attributeName, type);
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static void requireSingleAttribute(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(attributeName));
        }
        ParseUtils.requireNoNamespaceAttribute(reader, 0);
        if (!attributeName.equals(reader.getAttributeLocalName(0))) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
        if (count > 1) {
            throw ParseUtils.unexpectedAttribute(reader, 1);
        }
    }

    public static String[] requireAttributes(XMLExtendedStreamReader reader, String ... attributeNames) throws XMLStreamException {
        int length = attributeNames.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            String name = attributeNames[i];
            String value = reader.getAttributeValue(null, name);
            if (value == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(name));
            }
            result[i] = value;
        }
        return result;
    }

    public static boolean isNoNamespaceAttribute(XMLExtendedStreamReader reader, int index) {
        String namespace = reader.getAttributeNamespace(index);
        return namespace == null || "".equals(namespace);
    }

    public static void requireNoNamespaceAttribute(XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        if (!ParseUtils.isNoNamespaceAttribute(reader, index)) {
            throw ParseUtils.unexpectedAttribute(reader, index);
        }
    }

    public static ModelNode parseBoundedIntegerAttribute(XMLExtendedStreamReader reader, int index, int minInclusive, int maxInclusive, boolean allowExpression) throws XMLStreamException {
        ModelNode expression;
        String stringValue = reader.getAttributeValue(index);
        if (allowExpression && (expression = ParseUtils.parsePossibleExpression(stringValue)).getType() == ModelType.EXPRESSION) {
            return expression;
        }
        try {
            int value = Integer.parseInt(stringValue);
            if (value < minInclusive || value > maxInclusive) {
                throw new XMLStreamException("Illegal value " + value + " for attribute '" + reader.getAttributeName(index) + "' must be between " + minInclusive + " and " + maxInclusive + " (inclusive)", reader.getLocation());
            }
            return new ModelNode().set(value);
        }
        catch (NumberFormatException nfe) {
            throw new XMLStreamException("Illegal value '" + stringValue + "' for attribute '" + reader.getAttributeName(index) + "' must be an integer", reader.getLocation(), nfe);
        }
    }

    public static ModelNode parsePossibleExpression(String value) {
        ModelNode result = new ModelNode();
        int openIdx = value.indexOf("${");
        if (openIdx > -1 && value.lastIndexOf(125) > openIdx) {
            result.setExpression(value);
        } else {
            result.set(value);
        }
        return result;
    }

    public static String getWarningMessage(String msg, Location location) {
        return String.format("Parsing problem at [row,col]:[%d ,%d]\nMessage: ", location.getLineNumber(), location.getColumnNumber(), msg);
    }
}

