/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.SubsystemTransformer;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;

public class ExtensionRegistry {
    private final ProcessType processType;
    private SubsystemXmlWriterRegistry writerRegistry;
    private volatile PathManager pathManager;
    private volatile ManagementResourceRegistration profileRegistration;
    private volatile ManagementResourceRegistration deploymentsRegistration;
    private final ConcurrentMap<String, ExtensionInfo> extensions = new ConcurrentHashMap<String, ExtensionInfo>();
    private final ConcurrentMap<String, String> reverseMap = new ConcurrentHashMap<String, String>();
    private final RunningModeControl runningModeControl;
    private boolean unnamedMerged;
    private final ConcurrentHashMap<String, SubsystemInformation> subsystemsInfo = new ConcurrentHashMap();
    private final TransformerRegistry transformerRegistry = TransformerRegistry.Factory.create(this);

    public ExtensionRegistry(ProcessType processType, RunningModeControl runningModeControl) {
        this.processType = processType;
        this.runningModeControl = runningModeControl;
    }

    public ProcessType getProcessType() {
        return this.processType;
    }

    public void setWriterRegistry(SubsystemXmlWriterRegistry writerRegistry) {
        this.writerRegistry = writerRegistry;
    }

    public void setPathManager(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    public void setSubsystemParentResourceRegistrations(ManagementResourceRegistration profileResourceRegistration, ManagementResourceRegistration deploymentsResourceRegistration) {
        assert (profileResourceRegistration != null) : "profileResourceRegistration is null";
        assert (this.profileRegistration == null) : "profileResourceRegistration is already set";
        this.profileRegistration = profileResourceRegistration;
        if (deploymentsResourceRegistration != null) {
            assert (this.deploymentsRegistration == null) : "deploymentsResourceRegistration is already set";
            PathAddress subdepAddress = PathAddress.pathAddress(PathElement.pathElement("subdeployment"));
            ManagementResourceRegistration subdeployments = deploymentsResourceRegistration.getSubModel(subdepAddress);
            this.deploymentsRegistration = subdeployments == null ? deploymentsResourceRegistration : new DeploymentManagementResourceRegistration(deploymentsResourceRegistration, subdeployments);
        }
    }

    public ManagementResourceRegistration getProfileRegistration() {
        return this.profileRegistration;
    }

    public SubsystemInformation getSubsystemInfo(String name) {
        return this.subsystemsInfo.get(name);
    }

    public Set<String> getExtensionModuleNames() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SubsystemInformation> getAvailableSubsystems(String moduleName) {
        this.mergeUnnamedParsers();
        Map<String, SubsystemInformation> result = null;
        ExtensionInfo info = (ExtensionInfo)this.extensions.get(moduleName);
        if (info != null) {
            ExtensionInfo extensionInfo = info;
            synchronized (extensionInfo) {
                return Collections.unmodifiableMap(new HashMap(info.subsystems));
            }
        }
        return result;
    }

    public ExtensionParsingContext getExtensionParsingContext(String moduleName, XMLMapper xmlMapper) {
        return new ExtensionParsingContextImpl(moduleName, xmlMapper);
    }

    public ExtensionContext getExtensionContext(String moduleName) {
        return new ExtensionContextImpl(moduleName, this.pathManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnnamedNamespaces(String moduleName) {
        Set<String> result;
        this.mergeUnnamedParsers();
        ExtensionInfo extension = (ExtensionInfo)this.extensions.get(moduleName);
        if (extension != null) {
            ExtensionInfo extensionInfo = extension;
            synchronized (extensionInfo) {
                result = new HashSet<String>(extension.unnamedParsers);
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtension(Resource rootResource, String moduleName) throws IllegalStateException {
        ManagementResourceRegistration profileReg = this.profileRegistration;
        if (profileReg == null) {
            return;
        }
        ManagementResourceRegistration deploymentsReg = this.deploymentsRegistration;
        ExtensionInfo extension = (ExtensionInfo)this.extensions.remove(moduleName);
        if (extension != null) {
            ExtensionInfo extensionInfo = extension;
            synchronized (extensionInfo) {
                Set subsystemNames = extension.subsystems.keySet();
                for (String string : subsystemNames) {
                    if (rootResource.getChild(PathElement.pathElement("subsystem", string)) == null) continue;
                    this.extensions.put(moduleName, extension);
                    throw ControllerMessages.MESSAGES.removingExtensionWithRegisteredSubsystem(moduleName, string);
                }
                for (Map.Entry entry : extension.subsystems.entrySet()) {
                    String subsystem = (String)entry.getKey();
                    profileReg.unregisterSubModel(PathElement.pathElement("subsystem", subsystem));
                    if (deploymentsReg != null) {
                        deploymentsReg.unregisterSubModel(PathElement.pathElement("subsystem", subsystem));
                    }
                    if (extension.xmlMapper == null) continue;
                    SubsystemInformationImpl subsystemInformation = (SubsystemInformationImpl)SubsystemInformationImpl.class.cast(entry.getValue());
                    for (String namespace : subsystemInformation.getXMLNamespaces()) {
                        extension.xmlMapper.unregisterRootElement(new QName(namespace, "subsystem"));
                    }
                }
                if (extension.xmlMapper != null) {
                    for (String string : extension.unnamedParsers) {
                        extension.xmlMapper.unregisterRootElement(new QName(string, "subsystem"));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConcurrentMap<String, ExtensionInfo> concurrentMap = this.extensions;
        synchronized (concurrentMap) {
            this.profileRegistration = null;
            this.deploymentsRegistration = null;
            this.extensions.clear();
            this.reverseMap.clear();
            this.unnamedMerged = false;
        }
    }

    public void recordSubsystemVersions(String moduleName, ModelNode subsystems) {
        Map<String, SubsystemInformation> subsystemsInfo = this.getAvailableSubsystems(moduleName);
        if (subsystemsInfo != null && !subsystemsInfo.isEmpty()) {
            for (Map.Entry<String, SubsystemInformation> entry : subsystemsInfo.entrySet()) {
                subsystems.add(entry.getKey(), entry.getValue().getManagementInterfaceMajorVersion() + "." + entry.getValue().getManagementInterfaceMinorVersion());
            }
        }
    }

    private ExtensionInfo getExtensionInfo(String extensionModuleName) {
        ExtensionInfo result = (ExtensionInfo)this.extensions.get(extensionModuleName);
        if (result == null) {
            result = new ExtensionInfo(extensionModuleName);
            ExtensionInfo existing = this.extensions.putIfAbsent(extensionModuleName, result);
            result = existing == null ? result : existing;
        }
        return result;
    }

    private void checkNewSubystem(String extensionModuleName, String subsystemName) {
        String existingModule = this.reverseMap.putIfAbsent(subsystemName, extensionModuleName);
        if (existingModule != null && !extensionModuleName.equals(existingModule)) {
            throw ControllerMessages.MESSAGES.duplicateSubsystem(subsystemName, extensionModuleName, existingModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeUnnamedParsers() {
        ConcurrentMap<String, ExtensionInfo> concurrentMap = this.extensions;
        synchronized (concurrentMap) {
            if (!this.unnamedMerged) {
                Iterator i$ = this.extensions.values().iterator();
                while (i$.hasNext()) {
                    ExtensionInfo extension;
                    ExtensionInfo extensionInfo = extension = (ExtensionInfo)i$.next();
                    synchronized (extensionInfo) {
                        if (extension.unnamedParsers.size() > 0 && extension.subsystems.size() == 1) {
                            SubsystemInformationImpl info = (SubsystemInformationImpl)SubsystemInformationImpl.class.cast(extension.subsystems.values().iterator().next());
                            for (String unnamed : extension.unnamedParsers) {
                                info.addParsingNamespace(unnamed);
                            }
                            extension.unnamedParsers.clear();
                        }
                    }
                }
                this.unnamedMerged = true;
            }
        }
    }

    public TransformerRegistry getTransformerRegistry() {
        return this.transformerRegistry;
    }

    private static class DeploymentManagementResourceRegistration
    implements ManagementResourceRegistration {
        private final ManagementResourceRegistration deployments;
        private final ManagementResourceRegistration subdeployments;

        private DeploymentManagementResourceRegistration(ManagementResourceRegistration deployments, ManagementResourceRegistration subdeployments) {
            this.deployments = deployments;
            this.subdeployments = subdeployments;
        }

        @Override
        public boolean isRuntimeOnly() {
            return this.deployments.isRuntimeOnly();
        }

        @Override
        public void setRuntimeOnly(boolean runtimeOnly) {
            this.deployments.setRuntimeOnly(runtimeOnly);
            this.subdeployments.setRuntimeOnly(runtimeOnly);
        }

        @Override
        public boolean isRemote() {
            return this.deployments.isRemote();
        }

        @Override
        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return this.deployments.getOperationHandler(address, operationName);
        }

        @Override
        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return this.deployments.getOperationDescription(address, operationName);
        }

        @Override
        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return this.deployments.getOperationFlags(address, operationName);
        }

        @Override
        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return this.deployments.getOperationEntry(address, operationName);
        }

        @Override
        public Set<String> getAttributeNames(PathAddress address) {
            return this.deployments.getAttributeNames(address);
        }

        @Override
        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return this.deployments.getAttributeAccess(address, attributeName);
        }

        @Override
        public Set<String> getChildNames(PathAddress address) {
            return this.deployments.getChildNames(address);
        }

        @Override
        public Set<PathElement> getChildAddresses(PathAddress address) {
            return this.deployments.getChildAddresses(address);
        }

        @Override
        public DescriptionProvider getModelDescription(PathAddress address) {
            return this.deployments.getModelDescription(address);
        }

        @Override
        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return this.deployments.getOperationDescriptions(address, inherited);
        }

        @Override
        public ProxyController getProxyController(PathAddress address) {
            return this.deployments.getProxyController(address);
        }

        @Override
        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return this.deployments.getProxyControllers(address);
        }

        @Override
        public ManagementResourceRegistration getOverrideModel(String name) {
            return this.deployments.getOverrideModel(name);
        }

        @Override
        public ManagementResourceRegistration getSubModel(PathAddress address) {
            return this.deployments.getSubModel(address);
        }

        @Override
        public ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
            ManagementResourceRegistration depl = this.deployments.registerSubModel(address, descriptionProvider);
            ManagementResourceRegistration subdepl = this.subdeployments.registerSubModel(address, descriptionProvider);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
            ManagementResourceRegistration depl = this.deployments.registerSubModel(resourceDefinition);
            ManagementResourceRegistration subdepl = this.subdeployments.registerSubModel(resourceDefinition);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public void unregisterSubModel(PathElement address) {
            this.deployments.unregisterSubModel(address);
            this.subdeployments.unregisterSubModel(address);
        }

        @Override
        public boolean isAllowsOverride() {
            return this.deployments.isAllowsOverride();
        }

        @Override
        public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
            ManagementResourceRegistration depl = this.deployments.registerOverrideModel(name, descriptionProvider);
            ManagementResourceRegistration subdepl = this.subdeployments.registerOverrideModel(name, descriptionProvider);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public void unregisterOverrideModel(String name) {
            this.deployments.unregisterOverrideModel(name);
            this.subdeployments.unregisterOverrideModel(name);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, EnumSet<OperationEntry.Flag> flags) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, flags);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, flags);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType, flags);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType, flags);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, EnumSet<OperationEntry.Flag> flags) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, flags);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, flags);
        }

        @Override
        public void unregisterOperationHandler(String operationName) {
            this.deployments.unregisterOperationHandler(operationName);
            this.subdeployments.unregisterOperationHandler(operationName);
        }

        @Override
        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
            this.deployments.registerReadWriteAttribute(attributeName, readHandler, writeHandler, storage);
            this.subdeployments.registerReadWriteAttribute(attributeName, readHandler, writeHandler, storage);
        }

        @Override
        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
            this.deployments.registerReadWriteAttribute(attributeName, readHandler, writeHandler, flags);
            this.subdeployments.registerReadWriteAttribute(attributeName, readHandler, writeHandler, flags);
        }

        @Override
        public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
            this.deployments.registerReadWriteAttribute(definition, readHandler, writeHandler);
            this.subdeployments.registerReadWriteAttribute(definition, readHandler, writeHandler);
        }

        @Override
        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
            this.deployments.registerReadOnlyAttribute(attributeName, readHandler, storage);
            this.subdeployments.registerReadOnlyAttribute(attributeName, readHandler, storage);
        }

        @Override
        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
            this.deployments.registerReadOnlyAttribute(attributeName, readHandler, flags);
            this.subdeployments.registerReadOnlyAttribute(attributeName, readHandler, flags);
        }

        @Override
        public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
            this.deployments.registerReadOnlyAttribute(definition, readHandler);
            this.subdeployments.registerReadOnlyAttribute(definition, readHandler);
        }

        @Override
        public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
            this.deployments.registerMetric(attributeName, metricHandler);
            this.subdeployments.registerMetric(attributeName, metricHandler);
        }

        @Override
        public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
            this.deployments.registerMetric(definition, metricHandler);
            this.subdeployments.registerMetric(definition, metricHandler);
        }

        @Override
        public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
            this.deployments.registerMetric(attributeName, metricHandler, flags);
            this.subdeployments.registerMetric(attributeName, metricHandler, flags);
        }

        @Override
        public void unregisterAttribute(String attributeName) {
            this.deployments.unregisterAttribute(attributeName);
            this.subdeployments.unregisterAttribute(attributeName);
        }

        @Override
        public void registerProxyController(PathElement address, ProxyController proxyController) {
            this.deployments.registerProxyController(address, proxyController);
            this.subdeployments.registerProxyController(address, proxyController);
        }

        @Override
        public void unregisterProxyController(PathElement address) {
            this.deployments.unregisterProxyController(address);
            this.subdeployments.unregisterProxyController(address);
        }
    }

    public class ExtensionInfo {
        private final Map<String, SubsystemInformation> subsystems = new HashMap<String, SubsystemInformation>();
        private final Set<String> unnamedParsers = new HashSet<String>();
        private final String extensionModuleName;
        private XMLMapper xmlMapper;

        public ExtensionInfo(String extensionModuleName) {
            this.extensionModuleName = extensionModuleName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SubsystemInformationImpl getSubsystemInfo(String subsystemName) {
            ExtensionRegistry.this.checkNewSubystem(this.extensionModuleName, subsystemName);
            ExtensionInfo extensionInfo = this;
            synchronized (extensionInfo) {
                SubsystemInformationImpl subsystem = (SubsystemInformationImpl)SubsystemInformationImpl.class.cast(this.subsystems.get(subsystemName));
                if (subsystem == null) {
                    subsystem = new SubsystemInformationImpl();
                    this.subsystems.put(subsystemName, subsystem);
                }
                return subsystem;
            }
        }
    }

    public class SubsystemRegistrationImpl
    implements SubsystemRegistration {
        private final String name;

        private SubsystemRegistrationImpl(String name) {
            this.name = name;
        }

        @Override
        public ManagementResourceRegistration registerSubsystemModel(DescriptionProvider descriptionProvider) {
            assert (descriptionProvider != null) : "descriptionProvider is null";
            PathElement pathElement = PathElement.pathElement("subsystem", this.name);
            return this.registerSubsystemModel(new SimpleResourceDefinition(pathElement, descriptionProvider));
        }

        @Override
        public ManagementResourceRegistration registerSubsystemModel(ResourceDefinition resourceDefinition) {
            assert (resourceDefinition != null) : "resourceDefinition is null";
            ManagementResourceRegistration profileReg = ExtensionRegistry.this.profileRegistration;
            if (profileReg == null) {
                profileReg = this.getDummyRegistration();
            }
            return profileReg.registerSubModel(resourceDefinition);
        }

        @Override
        public ManagementResourceRegistration registerDeploymentModel(DescriptionProvider descriptionProvider) {
            assert (descriptionProvider != null) : "descriptionProvider is null";
            PathElement pathElement = PathElement.pathElement("subsystem", this.name);
            return this.registerDeploymentModel(new SimpleResourceDefinition(pathElement, descriptionProvider));
        }

        @Override
        public ManagementResourceRegistration registerDeploymentModel(ResourceDefinition resourceDefinition) {
            assert (resourceDefinition != null) : "resourceDefinition is null";
            ManagementResourceRegistration deploymentsReg = ExtensionRegistry.this.deploymentsRegistration;
            ManagementResourceRegistration base = deploymentsReg != null ? deploymentsReg : this.getDummyRegistration();
            return base.registerSubModel(resourceDefinition);
        }

        @Override
        public void registerXMLElementWriter(XMLElementWriter<SubsystemMarshallingContext> writer) {
            ExtensionRegistry.this.writerRegistry.registerSubsystemWriter(this.name, writer);
        }

        @Override
        public void registerSubsystemTransformer(SubsystemTransformer subsystemTransformer) {
            ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformer(this.name, subsystemTransformer);
        }

        private ManagementResourceRegistration getDummyRegistration() {
            return ManagementResourceRegistration.Factory.create(new DescriptionProvider(){

                @Override
                public ModelNode getModelDescription(Locale locale) {
                    return new ModelNode();
                }
            });
        }
    }

    private class SubsystemInformationImpl
    implements SubsystemInformation {
        private Integer majorVersion;
        private Integer minorVersion;
        private final List<String> parsingNamespaces = new ArrayList<String>();

        private SubsystemInformationImpl() {
        }

        @Override
        public List<String> getXMLNamespaces() {
            return Collections.unmodifiableList(this.parsingNamespaces);
        }

        void addParsingNamespace(String namespace) {
            this.parsingNamespaces.add(namespace);
        }

        @Override
        public Integer getManagementInterfaceMajorVersion() {
            return this.majorVersion;
        }

        private void setMajorVersion(Integer majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public Integer getManagementInterfaceMinorVersion() {
            return this.minorVersion;
        }

        private void setMinorVersion(Integer minorVersion) {
            this.minorVersion = minorVersion;
        }
    }

    public class ExtensionContextImpl
    implements ExtensionContext {
        private final ExtensionInfo extension;
        private final PathManager pathManager;
        private String subsystemName;

        private ExtensionContextImpl(String extensionName, PathManager pathManager) {
            assert (pathManager != null || !ExtensionRegistry.this.processType.isServer()) : "pathManager is null";
            this.pathManager = pathManager;
            this.extension = ExtensionRegistry.this.getExtensionInfo(extensionName);
        }

        @Override
        public SubsystemRegistration registerSubsystem(String name, int majorVersion, int minorVersion) throws IllegalArgumentException, IllegalStateException {
            assert (name != null) : "name is null";
            this.subsystemName = name;
            ExtensionRegistry.this.checkNewSubystem(this.extension.extensionModuleName, name);
            SubsystemInformationImpl info = this.extension.getSubsystemInfo(name);
            info.setMajorVersion(majorVersion);
            info.setMinorVersion(minorVersion);
            ExtensionRegistry.this.subsystemsInfo.put(name, info);
            return new SubsystemRegistrationImpl(name);
        }

        @Override
        public ProcessType getProcessType() {
            return ExtensionRegistry.this.processType;
        }

        @Override
        public RunningMode getRunningMode() {
            return ExtensionRegistry.this.runningModeControl.getRunningMode();
        }

        @Override
        public boolean isRuntimeOnlyRegistrationValid() {
            return ExtensionRegistry.this.processType.isServer() && ExtensionRegistry.this.runningModeControl.getRunningMode() != RunningMode.ADMIN_ONLY;
        }

        @Override
        public PathManager getPathManager() {
            if (!ExtensionRegistry.this.processType.isServer()) {
                throw ControllerMessages.MESSAGES.pathManagerNotAvailable(ExtensionRegistry.this.processType);
            }
            return this.pathManager;
        }
    }

    private class ExtensionParsingContextImpl
    implements ExtensionParsingContext {
        private final ExtensionInfo extension;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExtensionParsingContextImpl(String extensionName, XMLMapper xmlMapper) {
            this.extension = ExtensionRegistry.this.getExtensionInfo(extensionName);
            if (xmlMapper != null) {
                ExtensionInfo extensionInfo = this.extension;
                synchronized (extensionInfo) {
                    this.extension.xmlMapper = xmlMapper;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSubsystemXmlMapping(String namespaceUri, XMLElementReader<List<ModelNode>> reader) {
            assert (namespaceUri != null) : "namespaceUri is null";
            ConcurrentMap concurrentMap = ExtensionRegistry.this.extensions;
            synchronized (concurrentMap) {
                ExtensionInfo extensionInfo = this.extension;
                synchronized (extensionInfo) {
                    if (this.extension.xmlMapper != null) {
                        this.extension.xmlMapper.registerRootElement(new QName(namespaceUri, "subsystem"), reader);
                    }
                    this.extension.unnamedParsers.add(namespaceUri);
                }
                ExtensionRegistry.this.unnamedMerged = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSubsystemXmlMapping(String subsystemName, String namespaceUri, XMLElementReader<List<ModelNode>> reader) {
            assert (subsystemName != null) : "subsystemName is null";
            assert (namespaceUri != null) : "namespaceUri is null";
            ExtensionInfo extensionInfo = this.extension;
            synchronized (extensionInfo) {
                this.extension.getSubsystemInfo(subsystemName).addParsingNamespace(namespaceUri);
                if (this.extension.xmlMapper != null) {
                    this.extension.xmlMapper.registerRootElement(new QName(namespaceUri, "subsystem"), reader);
                }
            }
        }

        @Override
        public void setDeploymentXmlMapping(String namespaceUri, XMLElementReader<ModelNode> reader) {
        }

        @Override
        public void setDeploymentXmlMapping(String subsystemName, String namespaceUri, XMLElementReader<ModelNode> reader) {
        }
    }
}

