/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

abstract class AbstractDeploymentHandler {
    protected static final List<String> CONTENT_ADDITION_PARAMETERS = Arrays.asList("input-stream-index", "bytes", "url");

    AbstractDeploymentHandler() {
    }

    protected static String asString(ModelNode node, String name) {
        return node.has(name) ? node.require(name).asString() : null;
    }

    protected static OperationFailedException createFailureException(String format, Object ... params) {
        return AbstractDeploymentHandler.createFailureException(String.format(format, params));
    }

    protected static OperationFailedException createFailureException(Throwable cause, String format, Object ... params) {
        return AbstractDeploymentHandler.createFailureException(cause, String.format(format, params));
    }

    protected static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }

    protected static OperationFailedException createFailureException(Throwable cause, String msg) {
        return new OperationFailedException(cause, new ModelNode().set(msg));
    }

    protected static InputStream getInputStream(OperationContext context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        String message = "";
        if (operation.hasDefined("input-stream-index")) {
            int streamIndex = operation.get("input-stream-index").asInt();
            message = "Null stream at index " + streamIndex;
            in = context.getAttachmentStream(streamIndex);
        } else if (operation.hasDefined("bytes")) {
            message = "Invalid byte stream.";
            in = new ByteArrayInputStream(operation.get("bytes").asBytes());
        } else if (operation.hasDefined("url")) {
            String urlSpec = operation.get("url").asString();
            try {
                message = "Invalid url stream.";
                in = new URL(urlSpec).openStream();
            }
            catch (MalformedURLException e) {
                throw AbstractDeploymentHandler.createFailureException(message);
            }
            catch (IOException e) {
                throw AbstractDeploymentHandler.createFailureException(message);
            }
        }
        if (in == null) {
            throw AbstractDeploymentHandler.createFailureException(message);
        }
        return in;
    }

    protected static boolean hasValidContentAdditionParameterDefined(ModelNode operation) {
        for (String s : CONTENT_ADDITION_PARAMETERS) {
            if (!operation.hasDefined(s)) continue;
            return true;
        }
        return false;
    }

    protected static void validateOnePieceOfContent(ModelNode content) throws OperationFailedException {
        if (content.asList().size() != 1) {
            throw AbstractDeploymentHandler.createFailureException("Only 1 piece of content is current supported (JBAS-9020)");
        }
    }
}

