/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.ModelController;
import org.jboss.as.domain.http.server.ConsoleHandler;
import org.jboss.as.domain.http.server.DomainApiHandler;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.com.sun.net.httpserver.HttpsConfigurator;
import org.jboss.com.sun.net.httpserver.HttpsParameters;
import org.jboss.com.sun.net.httpserver.HttpsServer;

public class ManagementHttpServer {
    private final HttpServer httpServer;
    private final HttpServer secureHttpServer;
    private SecurityRealm securityRealm;
    private List<ManagementHttpHandler> handlers = new LinkedList<ManagementHttpHandler>();

    private ManagementHttpServer(HttpServer httpServer, HttpServer secureHttpServer, SecurityRealm securityRealm) {
        this.httpServer = httpServer;
        this.secureHttpServer = secureHttpServer;
        this.securityRealm = securityRealm;
    }

    private void addHandler(ManagementHttpHandler handler) {
        this.handlers.add(handler);
    }

    public void start() {
        this.start(this.httpServer);
        this.start(this.secureHttpServer);
    }

    private void start(HttpServer httpServer) {
        if (httpServer == null) {
            return;
        }
        for (ManagementHttpHandler current : this.handlers) {
            current.start(httpServer, this.securityRealm);
        }
        httpServer.start();
    }

    public void stop() {
        this.stop(this.httpServer);
        this.stop(this.secureHttpServer);
    }

    private void stop(HttpServer httpServer) {
        if (httpServer == null) {
            return;
        }
        httpServer.stop(0);
        for (ManagementHttpHandler current : this.handlers) {
            current.stop(httpServer);
        }
    }

    public static ManagementHttpServer create(InetSocketAddress bindAddress, InetSocketAddress secureBindAddress, int backlog, ModelController modelController, Executor executor, SecurityRealm securityRealm) throws IOException {
        HttpServer httpServer = null;
        if (bindAddress != null) {
            httpServer = HttpServer.create((InetSocketAddress)bindAddress, (int)backlog);
            httpServer.setExecutor(executor);
        }
        HttpsServer secureHttpServer = null;
        if (secureBindAddress != null) {
            secureHttpServer = HttpsServer.create((InetSocketAddress)secureBindAddress, (int)backlog);
            SSLContext context = securityRealm.getSSLContext();
            secureHttpServer.setHttpsConfigurator(new HttpsConfigurator(context){

                public void configure(HttpsParameters params) {
                    super.configure(params);
                }
            });
            secureHttpServer.setExecutor(executor);
        }
        ManagementHttpServer managementHttpServer = new ManagementHttpServer(httpServer, (HttpServer)secureHttpServer, securityRealm);
        managementHttpServer.addHandler(new DomainApiHandler(modelController));
        managementHttpServer.addHandler(new ConsoleHandler());
        return managementHttpServer;
    }
}

