/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.InterceptorEnvironment;
import org.jboss.as.ee.component.ManagedReferenceInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceLifecycleMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceReleaseInterceptorFactory;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.TCCLInterceptor;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.server.deployment.reflect.ProxyMetadataSource;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.invocation.proxy.ProxyConfiguration;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.invocation.proxy.reflection.ReflectionMetadataSource;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ConstructedValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class ComponentDescription
implements ResourceInjectionTarget {
    private static final DefaultComponentConfigurator FIRST_CONFIGURATOR = new DefaultComponentConfigurator();
    private static final AtomicInteger PROXY_ID = new AtomicInteger(0);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final ServiceName serviceName;
    private ServiceName contextServiceName;
    private final String componentName;
    private final String componentClassName;
    private final EEModuleDescription moduleDescription;
    private final Set<ViewDescription> views = new HashSet<ViewDescription>();
    private final Map<String, InterceptorClassDescription> interceptorClassOverrides = new HashMap<String, InterceptorClassDescription>();
    private List<InterceptorDescription> classInterceptors = new ArrayList<InterceptorDescription>();
    private List<InterceptorDescription> defaultInterceptors = new ArrayList<InterceptorDescription>();
    private final Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = new HashMap<MethodIdentifier, List<InterceptorDescription>>();
    private final Set<MethodIdentifier> methodExcludeDefaultInterceptors = new HashSet<MethodIdentifier>();
    private final Set<MethodIdentifier> methodExcludeClassInterceptors = new HashSet<MethodIdentifier>();
    private Set<InterceptorDescription> allInterceptors;
    private boolean excludeDefaultInterceptors = false;
    private final Map<ServiceName, ServiceBuilder.DependencyType> dependencies = new HashMap<ServiceName, ServiceBuilder.DependencyType>();
    private ComponentNamingMode namingMode = ComponentNamingMode.USE_MODULE;
    private DeploymentDescriptorEnvironment deploymentDescriptorEnvironment;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final Map<String, Map<InjectionTarget, ResourceInjectionConfiguration>> resourceInjections = new HashMap<String, Map<InjectionTarget, ResourceInjectionConfiguration>>();
    private final Deque<ComponentConfigurator> configurators = new ArrayDeque<ComponentConfigurator>();
    private String beanDeploymentArchiveId;

    public ComponentDescription(String componentName, String componentClassName, EEModuleDescription moduleDescription, ServiceName deploymentUnitServiceName) {
        this.moduleDescription = moduleDescription;
        if (componentName == null) {
            throw EeMessages.MESSAGES.nullVar("name");
        }
        if (componentClassName == null) {
            throw EeMessages.MESSAGES.nullVar("componentClassName");
        }
        if (moduleDescription == null) {
            throw EeMessages.MESSAGES.nullVar("moduleDescription");
        }
        if (deploymentUnitServiceName == null) {
            throw EeMessages.MESSAGES.nullVar("deploymentUnitServiceName");
        }
        this.serviceName = BasicComponent.serviceNameOf(deploymentUnitServiceName, componentName);
        this.componentName = componentName;
        this.componentClassName = componentClassName;
        this.configurators.addLast(FIRST_CONFIGURATOR);
    }

    public ComponentConfiguration createConfiguration(ClassIndex classIndex, ClassLoader moduleClassLoader, ModuleLoader moduleLoader) {
        return new ComponentConfiguration(this, classIndex, moduleClassLoader, moduleLoader);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setContextServiceName(ServiceName contextServiceName) {
        this.contextServiceName = contextServiceName;
    }

    public ServiceName getContextServiceName() {
        if (this.contextServiceName != null) {
            return this.contextServiceName;
        }
        if (this.getNamingMode() == ComponentNamingMode.CREATE) {
            return ContextNames.contextServiceNameOfComponent((String)this.getApplicationName(), (String)this.getModuleName(), (String)this.getComponentName());
        }
        if (this.getNamingMode() == ComponentNamingMode.USE_MODULE) {
            return ContextNames.contextServiceNameOfModule((String)this.getApplicationName(), (String)this.getModuleName());
        }
        throw new IllegalStateException();
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public ServiceName getStartServiceName() {
        return this.serviceName.append(new String[]{"START"});
    }

    public ServiceName getCreateServiceName() {
        return this.serviceName.append(new String[]{"CREATE"});
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public String getModuleName() {
        return this.moduleDescription.getModuleName();
    }

    public String getApplicationName() {
        return this.moduleDescription.getApplicationName();
    }

    public List<InterceptorDescription> getClassInterceptors() {
        return this.classInterceptors;
    }

    public void setClassInterceptors(List<InterceptorDescription> classInterceptors) {
        this.classInterceptors = classInterceptors;
        this.allInterceptors = null;
    }

    public List<InterceptorDescription> getDefaultInterceptors() {
        return this.defaultInterceptors;
    }

    public void setDefaultInterceptors(List<InterceptorDescription> defaultInterceptors) {
        this.allInterceptors = null;
        this.defaultInterceptors = defaultInterceptors;
    }

    public Set<InterceptorDescription> getAllInterceptors() {
        if (this.allInterceptors == null) {
            this.allInterceptors = new HashSet<InterceptorDescription>();
            this.allInterceptors.addAll(this.classInterceptors);
            if (!this.excludeDefaultInterceptors) {
                this.allInterceptors.addAll(this.defaultInterceptors);
            }
            for (List<InterceptorDescription> interceptors : this.methodInterceptors.values()) {
                this.allInterceptors.addAll(interceptors);
            }
        }
        return this.allInterceptors;
    }

    public boolean isExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.allInterceptors = null;
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public void excludeDefaultInterceptors(MethodIdentifier method) {
        this.methodExcludeDefaultInterceptors.add(method);
    }

    public boolean isExcludeDefaultInterceptors(MethodIdentifier method) {
        return this.methodExcludeDefaultInterceptors.contains(method);
    }

    public void excludeClassInterceptors(MethodIdentifier method) {
        this.methodExcludeClassInterceptors.add(method);
    }

    public boolean isExcludeClassInterceptors(MethodIdentifier method) {
        return this.methodExcludeClassInterceptors.contains(method);
    }

    public void addClassInterceptor(InterceptorDescription description) {
        this.classInterceptors.add(description);
        this.allInterceptors = null;
    }

    public InterceptorDescription getClassInterceptor(String interceptorClassName) {
        for (InterceptorDescription interceptor : this.classInterceptors) {
            if (!interceptor.getInterceptorClassName().equals(interceptorClassName)) continue;
            return interceptor;
        }
        return null;
    }

    public Map<MethodIdentifier, List<InterceptorDescription>> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public void addMethodInterceptor(MethodIdentifier method, InterceptorDescription description) {
        List<InterceptorDescription> interceptors = this.methodInterceptors.get(method);
        if (interceptors == null) {
            interceptors = new ArrayList<InterceptorDescription>();
            this.methodInterceptors.put(method, interceptors);
        }
        String name = description.getInterceptorClassName();
        interceptors.add(description);
        this.allInterceptors = null;
    }

    public void setMethodInterceptors(MethodIdentifier identifier, List<InterceptorDescription> interceptorDescriptions) {
        this.methodInterceptors.put(identifier, interceptorDescriptions);
        this.methodExcludeClassInterceptors.add(identifier);
        this.methodExcludeDefaultInterceptors.add(identifier);
    }

    public void addInterceptorMethodOverride(String className, InterceptorClassDescription override) {
        this.interceptorClassOverrides.put(className, InterceptorClassDescription.merge(this.interceptorClassOverrides.get(className), override));
    }

    public ComponentNamingMode getNamingMode() {
        return this.namingMode;
    }

    public void setNamingMode(ComponentNamingMode namingMode) {
        if (namingMode == null) {
            throw EeMessages.MESSAGES.nullVar("namingMode");
        }
        this.namingMode = namingMode;
    }

    public EEModuleDescription getModuleDescription() {
        return this.moduleDescription;
    }

    public void addDependency(ServiceName serviceName, ServiceBuilder.DependencyType type) {
        if (serviceName == null) {
            throw EeMessages.MESSAGES.nullVar("serviceName");
        }
        if (type == null) {
            throw EeMessages.MESSAGES.nullVar("type");
        }
        Map<ServiceName, ServiceBuilder.DependencyType> dependencies = this.dependencies;
        ServiceBuilder.DependencyType dependencyType = dependencies.get(serviceName);
        if (dependencyType == ServiceBuilder.DependencyType.REQUIRED) {
            dependencies.put(serviceName, ServiceBuilder.DependencyType.REQUIRED);
        } else {
            dependencies.put(serviceName, type);
        }
    }

    public Map<ServiceName, ServiceBuilder.DependencyType> getDependencies() {
        return this.dependencies;
    }

    public DeploymentDescriptorEnvironment getDeploymentDescriptorEnvironment() {
        return this.deploymentDescriptorEnvironment;
    }

    public void setDeploymentDescriptorEnvironment(DeploymentDescriptorEnvironment deploymentDescriptorEnvironment) {
        this.deploymentDescriptorEnvironment = deploymentDescriptorEnvironment;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public Set<ViewDescription> getViews() {
        return this.views;
    }

    public boolean isTimerServiceApplicable() {
        return false;
    }

    public boolean isPassivationApplicable() {
        return false;
    }

    public Deque<ComponentConfigurator> getConfigurators() {
        return this.configurators;
    }

    public boolean isIntercepted() {
        return true;
    }

    public boolean isOptional() {
        return false;
    }

    private static InterceptorFactory weaved(final Collection<InterceptorFactory> interceptorFactories) {
        return new InterceptorFactory(){

            public Interceptor create(InterceptorFactoryContext context) {
                Interceptor[] interceptors = new Interceptor[interceptorFactories.size()];
                Iterator factories = interceptorFactories.iterator();
                for (int i = 0; i < interceptors.length; ++i) {
                    interceptors[i] = ((InterceptorFactory)factories.next()).create(context);
                }
                return Interceptors.getWeavedInterceptor((Interceptor[])interceptors);
            }
        };
    }

    public String getBeanDeploymentArchiveId() {
        return this.beanDeploymentArchiveId;
    }

    public void setBeanDeploymentArchiveId(String beanDeploymentArchiveId) {
        this.beanDeploymentArchiveId = beanDeploymentArchiveId;
    }

    @Override
    public void addResourceInjection(ResourceInjectionConfiguration injection) {
        String className = injection.getTarget().getClassName();
        Map<InjectionTarget, ResourceInjectionConfiguration> map = this.resourceInjections.get(className);
        if (map == null) {
            map = new HashMap<InjectionTarget, ResourceInjectionConfiguration>();
            this.resourceInjections.put(className, map);
        }
        map.put(injection.getTarget(), injection);
    }

    public Map<InjectionTarget, ResourceInjectionConfiguration> getResourceInjections(String className) {
        Map<InjectionTarget, ResourceInjectionConfiguration> injections = this.resourceInjections.get(className);
        if (injections == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(injections);
    }

    static class InjectedConfigurator
    implements DependencyConfigurator<ComponentStartService> {
        private final ResourceInjectionConfiguration injectionConfiguration;
        private final ComponentConfiguration configuration;
        private final DeploymentPhaseContext context;
        private final InjectedValue<ManagedReferenceFactory> managedReferenceFactoryValue;

        InjectedConfigurator(ResourceInjectionConfiguration injectionConfiguration, ComponentConfiguration configuration, DeploymentPhaseContext context, InjectedValue<ManagedReferenceFactory> managedReferenceFactoryValue) {
            this.injectionConfiguration = injectionConfiguration;
            this.configuration = configuration;
            this.context = context;
            this.managedReferenceFactoryValue = managedReferenceFactoryValue;
        }

        @Override
        public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
            InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(this.configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.USE_MODULE, this.configuration.getComponentName(), this.configuration.getModuleName(), this.configuration.getApplicationName());
            this.injectionConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, this.context, (Injector<ManagedReferenceFactory>)this.managedReferenceFactoryValue);
        }
    }

    private static class DefaultComponentConfigurator
    implements ComponentConfigurator {
        private DefaultComponentConfigurator() {
        }

        @Override
        public void configure(final DeploymentPhaseContext context, final ComponentDescription description, final ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            HashMap userPostActivatesByInterceptorClass;
            HashMap userPrePassivatesByInterceptorClass;
            HashMap userAroundTimeoutsByInterceptorClass;
            ArrayList componentUserAroundTimeout;
            DeploymentUnit deploymentUnit = context.getDeploymentUnit();
            final DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
            final Object instanceKey = BasicComponentInstance.INSTANCE_KEY;
            Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
            final EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            ProxyMetadataSource proxyReflectionIndex = (ProxyMetadataSource)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.PROXY_REFLECTION_INDEX);
            DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CLASS_INDEX);
            final boolean metadataComplete = MetadataCompleteMarker.isMetadataComplete(deploymentUnit);
            ArrayDeque<ManagedReferenceInterceptorFactory> instantiators = new ArrayDeque<ManagedReferenceInterceptorFactory>();
            final ArrayDeque injectors = new ArrayDeque();
            final ArrayDeque uninjectors = new ArrayDeque();
            ArrayDeque<ManagedReferenceReleaseInterceptorFactory> destructors = new ArrayDeque<ManagedReferenceReleaseInterceptorFactory>();
            final ClassReflectionIndex componentClassIndex = deploymentReflectionIndex.getClassIndex(configuration.getComponentClass());
            final ArrayList componentUserAroundInvoke = new ArrayList();
            final HashMap userAroundInvokesByInterceptorClass = new HashMap();
            final HashMap userPostConstructByInterceptorClass = new HashMap();
            final HashMap userPreDestroyByInterceptorClass = new HashMap();
            if (description.isTimerServiceApplicable()) {
                componentUserAroundTimeout = new ArrayList();
                userAroundTimeoutsByInterceptorClass = new HashMap();
            } else {
                componentUserAroundTimeout = null;
                userAroundTimeoutsByInterceptorClass = null;
            }
            if (description.isPassivationApplicable()) {
                userPrePassivatesByInterceptorClass = new HashMap();
                userPostActivatesByInterceptorClass = new HashMap();
            } else {
                userPrePassivatesByInterceptorClass = null;
                userPostActivatesByInterceptorClass = null;
            }
            ManagedReferenceFactory instanceFactory = configuration.getInstanceFactory();
            if (instanceFactory != null) {
                instantiators.addFirst(new ManagedReferenceInterceptorFactory(instanceFactory, instanceKey));
            } else {
                Constructor constructor = componentClassIndex.getConstructor(EMPTY_CLASS_ARRAY);
                if (constructor == null) {
                    throw EeMessages.MESSAGES.defaultConstructorNotFound(configuration.getComponentClass());
                }
                ValueManagedReferenceFactory factory = new ValueManagedReferenceFactory((Value)new ConstructedValue(constructor, Collections.emptyList()));
                instantiators.addFirst(new ManagedReferenceInterceptorFactory((ManagedReferenceFactory)factory, instanceKey));
            }
            destructors.addLast(new ManagedReferenceReleaseInterceptorFactory(instanceKey));
            new ClassDescriptionTraversal(configuration.getComponentClass(), applicationClasses){

                @Override
                public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    DefaultComponentConfigurator.this.mergeInjectionsForClass(clazz, classDescription, moduleDescription, description, configuration, context, injectors, instanceKey, uninjectors, metadataComplete);
                }
            }.run();
            ArrayList<InterceptorDescription> interceptorWithLifecycleCallbacks = new ArrayList<InterceptorDescription>();
            if (!description.isExcludeDefaultInterceptors()) {
                interceptorWithLifecycleCallbacks.addAll(description.getDefaultInterceptors());
            }
            interceptorWithLifecycleCallbacks.addAll(description.getClassInterceptors());
            for (InterceptorDescription interceptorDescription : description.getAllInterceptors()) {
                ClassIndex interceptorClass;
                final String interceptorClassName = interceptorDescription.getInterceptorClassName();
                try {
                    interceptorClass = classIndex.classIndex(interceptorClassName);
                }
                catch (ClassNotFoundException e) {
                    throw EeMessages.MESSAGES.cannotLoadInterceptor(e, interceptorClassName);
                }
                InterceptorEnvironment interceptorEnvironment = moduleDescription.getInterceptorEnvironment().get(interceptorClassName);
                if (interceptorEnvironment != null) {
                    description.getBindingConfigurations().addAll(interceptorEnvironment.getBindingConfigurations());
                    for (ResourceInjectionConfiguration injection : interceptorEnvironment.getResourceInjections()) {
                        description.addResourceInjection(injection);
                    }
                }
                final Class contextKey = interceptorClass.getModuleClass();
                configuration.getInterceptorContextKeys().add(contextKey);
                ClassReflectionIndex interceptorIndex = deploymentReflectionIndex.getClassIndex(interceptorClass.getModuleClass());
                Constructor constructor = interceptorIndex.getConstructor(EMPTY_CLASS_ARRAY);
                if (constructor == null) {
                    throw EeMessages.MESSAGES.defaultConstructorNotFoundOnComponent(interceptorClassName, configuration.getComponentClass());
                }
                instantiators.addFirst(new ManagedReferenceInterceptorFactory((ManagedReferenceFactory)new ValueManagedReferenceFactory((Value)new ConstructedValue(constructor, Collections.emptyList())), contextKey));
                destructors.addLast(new ManagedReferenceReleaseInterceptorFactory(contextKey));
                final boolean interceptorHasLifecycleCallbacks = interceptorWithLifecycleCallbacks.contains(interceptorDescription);
                new ClassDescriptionTraversal(interceptorClass.getModuleClass(), applicationClasses){

                    @Override
                    public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                        DefaultComponentConfigurator.this.mergeInjectionsForClass(clazz, classDescription, moduleDescription, description, configuration, context, injectors, contextKey, uninjectors, metadataComplete);
                        InterceptorClassDescription interceptorConfig = classDescription != null && !metadataComplete ? InterceptorClassDescription.merge(classDescription.getInterceptorClassDescription(), moduleDescription.getInterceptorClassOverride(clazz.getName())) : InterceptorClassDescription.merge(null, moduleDescription.getInterceptorClassOverride(clazz.getName()));
                        if (interceptorHasLifecycleCallbacks) {
                            MethodIdentifier postConstructMethodIdentifier = interceptorConfig.getPostConstruct();
                            this.handleInterceptorClass(clazz, postConstructMethodIdentifier, userPostConstructByInterceptorClass, true, true);
                            MethodIdentifier preDestroyMethodIdentifier = interceptorConfig.getPreDestroy();
                            this.handleInterceptorClass(clazz, preDestroyMethodIdentifier, userPreDestroyByInterceptorClass, true, true);
                        }
                        MethodIdentifier aroundInvokeMethodIdentifier = interceptorConfig.getAroundInvoke();
                        this.handleInterceptorClass(clazz, aroundInvokeMethodIdentifier, userAroundInvokesByInterceptorClass, false, false);
                        if (description.isTimerServiceApplicable()) {
                            MethodIdentifier aroundTimeoutMethodIdentifier = interceptorConfig.getAroundTimeout();
                            this.handleInterceptorClass(clazz, aroundTimeoutMethodIdentifier, userAroundTimeoutsByInterceptorClass, false, false);
                        }
                        if (description.isPassivationApplicable()) {
                            this.handleInterceptorClass(clazz, interceptorConfig.getPrePassivate(), userPrePassivatesByInterceptorClass, false, false);
                            this.handleInterceptorClass(clazz, interceptorConfig.getPostActivate(), userPostActivatesByInterceptorClass, false, false);
                        }
                    }

                    private void handleInterceptorClass(Class<?> clazz, MethodIdentifier methodIdentifier, Map<String, List<InterceptorFactory>> classMap, boolean changeMethod, boolean lifecycleMethod) throws DeploymentUnitProcessingException {
                        Method method;
                        if (methodIdentifier != null && DefaultComponentConfigurator.this.isNotOverriden(clazz, method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, clazz, (MethodIdentifier)methodIdentifier), interceptorClass.getModuleClass(), deploymentReflectionIndex)) {
                            ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(contextKey, method, changeMethod, lifecycleMethod);
                            List<InterceptorFactory> factories = classMap.get(interceptorClassName);
                            if (factories == null) {
                                factories = new ArrayList<InterceptorFactory>();
                                classMap.put(interceptorClassName, factories);
                            }
                            factories.add(interceptorFactory);
                        }
                    }
                }.run();
            }
            final ArrayList userPostConstruct = new ArrayList();
            final ArrayList userPreDestroy = new ArrayList();
            final ArrayList userPrePassivate = new ArrayList();
            final ArrayList userPostActivate = new ArrayList();
            for (InterceptorDescription interceptorClass : interceptorWithLifecycleCallbacks) {
                if (userPostConstructByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                    userPostConstruct.addAll((Collection)userPostConstructByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
                }
                if (userPreDestroyByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                    userPreDestroy.addAll((Collection)userPreDestroyByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
                }
                if (!description.isPassivationApplicable()) continue;
                if (userPrePassivatesByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                    userPrePassivate.addAll((Collection)userPrePassivatesByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
                }
                if (!userPostActivatesByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) continue;
                userPostActivate.addAll((Collection)userPostActivatesByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
            }
            new ClassDescriptionTraversal(configuration.getComponentClass(), applicationClasses){

                @Override
                public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    InterceptorClassDescription interceptorConfig = DefaultComponentConfigurator.this.mergeInterceptorConfig(clazz, classDescription, description, metadataComplete);
                    this.handleClassMethod(clazz, interceptorConfig.getPostConstruct(), userPostConstruct, true, true);
                    this.handleClassMethod(clazz, interceptorConfig.getPreDestroy(), userPreDestroy, true, true);
                    this.handleClassMethod(clazz, interceptorConfig.getAroundInvoke(), componentUserAroundInvoke, false, false);
                    if (description.isTimerServiceApplicable()) {
                        this.handleClassMethod(clazz, interceptorConfig.getAroundTimeout(), componentUserAroundTimeout, false, false);
                    }
                    if (description.isPassivationApplicable()) {
                        this.handleClassMethod(clazz, interceptorConfig.getPrePassivate(), userPrePassivate, false, false);
                        this.handleClassMethod(clazz, interceptorConfig.getPostActivate(), userPostActivate, false, false);
                    }
                }

                private void handleClassMethod(Class<?> clazz, MethodIdentifier methodIdentifier, List<InterceptorFactory> interceptors, boolean changeMethod, boolean lifecycleMethod) throws DeploymentUnitProcessingException {
                    Method method;
                    if (methodIdentifier != null && DefaultComponentConfigurator.this.isNotOverriden(clazz, method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, clazz, (MethodIdentifier)methodIdentifier), componentClassIndex.getIndexedClass(), deploymentReflectionIndex)) {
                        ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(instanceKey, method, changeMethod, lifecycleMethod);
                        interceptors.add(interceptorFactory);
                    }
                }
            }.run();
            ImmediateInterceptorFactory tcclInterceptor = new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor((ClassLoader)module.getClassLoader()));
            if (!injectors.isEmpty()) {
                configuration.addPostConstructInterceptor(ComponentDescription.weaved(injectors), 1792);
            }
            if (!instantiators.isEmpty()) {
                configuration.addPostConstructInterceptor(ComponentDescription.weaved(instantiators), 1536);
            }
            if (!userPostConstruct.isEmpty()) {
                configuration.addPostConstructInterceptor(ComponentDescription.weaved(userPostConstruct), 2816);
            }
            configuration.addPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 3840);
            configuration.addPostConstructInterceptor((InterceptorFactory)tcclInterceptor, 256);
            if (!uninjectors.isEmpty()) {
                configuration.addPreDestroyInterceptor(ComponentDescription.weaved(uninjectors), 1536);
            }
            if (!destructors.isEmpty()) {
                configuration.addPreDestroyInterceptor(ComponentDescription.weaved(destructors), 1792);
            }
            if (!userPreDestroy.isEmpty()) {
                configuration.addPreDestroyInterceptor(ComponentDescription.weaved(userPreDestroy), 2048);
            }
            configuration.addPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 2560);
            configuration.addPreDestroyInterceptor((InterceptorFactory)tcclInterceptor, 256);
            if (description.isPassivationApplicable()) {
                if (!userPrePassivate.isEmpty()) {
                    configuration.addPrePassivateInterceptor(ComponentDescription.weaved(userPrePassivate), 2048);
                }
                configuration.addPrePassivateInterceptor(Interceptors.getTerminalInterceptorFactory(), 2560);
                configuration.addPrePassivateInterceptor((InterceptorFactory)tcclInterceptor, 256);
                if (!userPostActivate.isEmpty()) {
                    configuration.addPostActivateInterceptor(ComponentDescription.weaved(userPostActivate), 2048);
                }
                configuration.addPostActivateInterceptor(Interceptors.getTerminalInterceptorFactory(), 2560);
                configuration.addPostActivateInterceptor((InterceptorFactory)tcclInterceptor, 256);
            }
            List<InterceptorDescription> classInterceptors = description.getClassInterceptors();
            Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = description.getMethodInterceptors();
            if (description.isIntercepted()) {
                for (Method method : configuration.getDefinedComponentMethods()) {
                    List<InterceptorDescription> methodLevelInterceptors;
                    List aroundTimeouts;
                    List aroundInvokes;
                    String interceptorClassName;
                    configuration.addComponentInterceptor(method, Interceptors.getInitialInterceptorFactory(), 256);
                    configuration.addComponentInterceptor(method, new ManagedReferenceMethodInterceptorFactory(instanceKey, method), 3072);
                    MethodIdentifier identifier = MethodIdentifier.getIdentifier(method.getReturnType(), (String)method.getName(), (Class[])method.getParameterTypes());
                    ArrayList userAroundInvokes = new ArrayList();
                    ArrayList userAroundTimeouts = new ArrayList();
                    if (!description.isExcludeDefaultInterceptors() && !description.isExcludeDefaultInterceptors(identifier)) {
                        for (InterceptorDescription interceptorDescription : description.getDefaultInterceptors()) {
                            interceptorClassName = interceptorDescription.getInterceptorClassName();
                            aroundInvokes = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                            if (aroundInvokes != null) {
                                userAroundInvokes.addAll(aroundInvokes);
                            }
                            if (!description.isTimerServiceApplicable() || (aroundTimeouts = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName)) == null) continue;
                            userAroundTimeouts.addAll(aroundTimeouts);
                        }
                    }
                    if (!description.isExcludeClassInterceptors(identifier)) {
                        for (InterceptorDescription interceptorDescription : classInterceptors) {
                            interceptorClassName = interceptorDescription.getInterceptorClassName();
                            aroundInvokes = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                            if (aroundInvokes != null) {
                                userAroundInvokes.addAll(aroundInvokes);
                            }
                            if (!description.isTimerServiceApplicable() || (aroundTimeouts = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName)) == null) continue;
                            userAroundTimeouts.addAll(aroundTimeouts);
                        }
                    }
                    if ((methodLevelInterceptors = methodInterceptors.get(identifier)) != null) {
                        for (InterceptorDescription methodLevelInterceptor : methodLevelInterceptors) {
                            List aroundTimeouts2;
                            String interceptorClassName2 = methodLevelInterceptor.getInterceptorClassName();
                            List aroundInvokes2 = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName2);
                            if (aroundInvokes2 != null) {
                                userAroundInvokes.addAll(aroundInvokes2);
                            }
                            if (!description.isTimerServiceApplicable() || (aroundTimeouts2 = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName2)) == null) continue;
                            userAroundTimeouts.addAll(aroundTimeouts2);
                        }
                    }
                    userAroundInvokes.addAll(componentUserAroundInvoke);
                    if (componentUserAroundTimeout != null) {
                        userAroundTimeouts.addAll(componentUserAroundTimeout);
                    }
                    configuration.addComponentInterceptor(method, new UserInterceptorFactory(ComponentDescription.weaved(userAroundInvokes), ComponentDescription.weaved(userAroundTimeouts)), 2560);
                }
            }
            for (ViewDescription view : description.getViews()) {
                ViewConfiguration viewConfiguration;
                Class viewClass;
                try {
                    viewClass = module.getClassLoader().loadClass(view.getViewClassName());
                }
                catch (ClassNotFoundException e) {
                    throw EeMessages.MESSAGES.cannotLoadViewClass(e, view.getViewClassName(), configuration);
                }
                ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
                proxyConfiguration.setProxyName(viewClass.getName() + "$$$view" + PROXY_ID.incrementAndGet());
                proxyConfiguration.setClassLoader((ClassLoader)module.getClassLoader());
                proxyConfiguration.setProtectionDomain(viewClass.getProtectionDomain());
                proxyConfiguration.setMetadataSource((ReflectionMetadataSource)proxyReflectionIndex);
                if (view.isSerializable()) {
                    proxyConfiguration.addAdditionalInterface(Serializable.class);
                    if (view.isUseWriteReplace()) {
                        proxyConfiguration.addAdditionalInterface(WriteReplaceInterface.class);
                    }
                }
                if (viewClass.isInterface()) {
                    proxyConfiguration.setSuperClass(Object.class);
                    proxyConfiguration.addAdditionalInterface(viewClass);
                    viewConfiguration = view.createViewConfiguration(viewClass, configuration, new ProxyFactory(proxyConfiguration));
                } else {
                    proxyConfiguration.setSuperClass(viewClass);
                    viewConfiguration = view.createViewConfiguration(viewClass, configuration, new ProxyFactory(proxyConfiguration));
                }
                for (ViewConfigurator configurator : view.getConfigurators()) {
                    configurator.configure(context, configuration, view, viewConfiguration);
                }
                configuration.getViews().add(viewConfiguration);
            }
            configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                @Override
                public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                    for (Map.Entry<ServiceName, ServiceBuilder.DependencyType> entry : description.getDependencies().entrySet()) {
                        serviceBuilder.addDependency(entry.getValue(), entry.getKey());
                    }
                }
            });
        }

        private void mergeInjectionsForClass(Class<?> clazz, EEModuleClassDescription classDescription, EEModuleDescription moduleDescription, ComponentDescription description, ComponentConfiguration configuration, DeploymentPhaseContext context, Deque<InterceptorFactory> injectors, Object instanceKey, Deque<InterceptorFactory> uninjectors, boolean metadataComplete) throws DeploymentUnitProcessingException {
            HashMap<InjectionTarget, ResourceInjectionConfiguration> mergedInjections = new HashMap<InjectionTarget, ResourceInjectionConfiguration>();
            if (classDescription != null && !metadataComplete) {
                mergedInjections.putAll(classDescription.getInjectionConfigurations());
            }
            mergedInjections.putAll(moduleDescription.getResourceInjections(clazz.getName()));
            mergedInjections.putAll(description.getResourceInjections(clazz.getName()));
            for (ResourceInjectionConfiguration injectionConfiguration : mergedInjections.values()) {
                Object valueContextKey = new Object();
                InjectedValue managedReferenceFactoryValue = new InjectedValue();
                configuration.getStartDependencies().add(new InjectedConfigurator(injectionConfiguration, configuration, context, (InjectedValue<ManagedReferenceFactory>)managedReferenceFactoryValue));
                injectors.addFirst(injectionConfiguration.getTarget().createInjectionInterceptorFactory(instanceKey, valueContextKey, (Value<ManagedReferenceFactory>)managedReferenceFactoryValue, context.getDeploymentUnit(), injectionConfiguration.isOptional()));
                uninjectors.addLast(new ManagedReferenceReleaseInterceptorFactory(valueContextKey));
            }
        }

        private InterceptorClassDescription mergeInterceptorConfig(Class<?> clazz, EEModuleClassDescription classDescription, ComponentDescription description, boolean metadataComplete) {
            InterceptorClassDescription interceptorConfig = classDescription != null && !metadataComplete ? InterceptorClassDescription.merge(classDescription.getInterceptorClassDescription(), (InterceptorClassDescription)description.interceptorClassOverrides.get(clazz.getName())) : InterceptorClassDescription.merge(null, (InterceptorClassDescription)description.interceptorClassOverrides.get(clazz.getName()));
            return interceptorConfig;
        }

        private boolean isNotOverriden(Class<?> clazz, Method method, Class<?> actualClass, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
            return Modifier.isPrivate(method.getModifiers()) || ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, actualClass, (Method)method).getDeclaringClass() == clazz;
        }
    }
}

