/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.EjbJarConfiguration;

public class EJBComponentCreateService
extends BasicComponentCreateService {
    private final ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> txAttrs;
    private final TransactionManagementType transactionManagementType;
    private final EjbJarConfiguration ejbJarConfiguration;

    public EJBComponentCreateService(ComponentConfiguration componentConfiguration, EjbJarConfiguration ejbJarConfiguration) {
        super(componentConfiguration);
        Set componentMethods;
        this.ejbJarConfiguration = ejbJarConfiguration;
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        this.transactionManagementType = ejbComponentDescription.getTransactionManagementType();
        this.txAttrs = this.transactionManagementType.equals((Object)TransactionManagementType.CONTAINER) ? new ConcurrentHashMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>>() : null;
        List views = componentConfiguration.getViews();
        if (views != null) {
            for (ViewConfiguration view : views) {
                MethodIntf viewType = ejbComponentDescription.getMethodIntf(view.getViewClass().getName());
                for (Method method : view.getProxyFactory().getCachedMethods()) {
                    this.processTxAttr(ejbComponentDescription, viewType, method);
                }
            }
        }
        if ((componentMethods = componentConfiguration.getDefinedComponentMethods()) != null) {
            for (Method method : componentMethods) {
                this.processTxAttr(ejbComponentDescription, MethodIntf.BEAN, method);
            }
        }
    }

    ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> getTxAttrs() {
        return this.txAttrs;
    }

    TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    EjbJarConfiguration getEjbJarConfiguration() {
        return this.ejbJarConfiguration;
    }

    private void processTxAttr(EJBComponentDescription ejbComponentDescription, MethodIntf methodIntf, Method method) {
        ConcurrentHashMap<ArrayKey, TransactionAttributeType> perMethod;
        if (this.getTransactionManagementType().equals((Object)TransactionManagementType.BEAN)) {
            return;
        }
        String methodName = method.getName();
        TransactionAttributeType txAttr = ejbComponentDescription.getTransactionAttribute(methodIntf, methodName, EJBComponentCreateService.toString(method.getParameterTypes()));
        ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>> perMethodIntf = (ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>>)this.txAttrs.get((Object)methodIntf);
        if (perMethodIntf == null) {
            perMethodIntf = new ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>>();
            this.txAttrs.put(methodIntf, perMethodIntf);
        }
        if ((perMethod = (ConcurrentHashMap<ArrayKey, TransactionAttributeType>)perMethodIntf.get(methodName)) == null) {
            perMethod = new ConcurrentHashMap<ArrayKey, TransactionAttributeType>();
            perMethodIntf.put(methodName, perMethod);
        }
        perMethod.put(new ArrayKey(method.getParameterTypes()), txAttr);
    }

    private static String[] toString(Class<?>[] a) {
        String[] result = new String[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i].getName();
        }
        return result;
    }
}

