/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.AccessTimeout;
import javax.ejb.LockType;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponentCreateService;
import org.jboss.as.ejb3.component.singleton.SingletonComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.ejb3.concurrency.spi.LockableComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StopContext;

public class SingletonComponent
extends SessionBeanComponent
implements LockableComponent {
    private static final Logger logger = Logger.getLogger(SingletonComponent.class);
    private SingletonComponentInstance singletonComponentInstance;
    private boolean initOnStartup;
    private LockType beanLevelLockType;
    private Map<EJBBusinessMethod, LockType> methodLockTypes;
    private Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts;

    public SingletonComponent(SingletonComponentCreateService singletonComponentCreateService) {
        super(singletonComponentCreateService);
        this.initOnStartup = singletonComponentCreateService.isInitOnStartup();
        this.beanLevelLockType = null;
        this.methodLockTypes = null;
        this.methodAccessTimeouts = null;
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        if (this.singletonComponentInstance != null) {
            throw new IllegalStateException("A singleton component instance has already been created for bean: " + this.getComponentName());
        }
        this.singletonComponentInstance = new SingletonComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors);
        return this.singletonComponentInstance;
    }

    synchronized ComponentInstance getComponentInstance() {
        if (this.singletonComponentInstance == null) {
            this.singletonComponentInstance = (SingletonComponentInstance)this.createInstance();
        }
        return this.singletonComponentInstance;
    }

    public void start() {
        super.start();
        if (this.initOnStartup) {
            logger.debug((Object)(this.getComponentName() + " bean is a @Startup (a.k.a init-on-startup) bean, creating/getting the singleton instance"));
            this.getComponentInstance();
        }
    }

    public void stop(StopContext stopContext) {
        this.destroySingletonInstance();
        super.stop(stopContext);
    }

    public LockType getLockType(Method method) {
        EJBBusinessMethod beanMethod = new EJBBusinessMethod(method.getName(), method.getParameterTypes());
        LockType lockType = this.methodLockTypes.get(beanMethod);
        if (lockType != null) {
            return lockType;
        }
        if (this.beanLevelLockType != null) {
            return this.beanLevelLockType;
        }
        return LockType.WRITE;
    }

    public AccessTimeout getAccessTimeout(Method method) {
        EJBBusinessMethod beanMethod = new EJBBusinessMethod(method.getName(), method.getParameterTypes());
        AccessTimeout accessTimeout = this.methodAccessTimeouts.get(beanMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        if (this.beanLevelAccessTimeout != null) {
            return this.beanLevelAccessTimeout;
        }
        return null;
    }

    public AccessTimeout getDefaultAccessTimeout() {
        return new AccessTimeout(){

            public long value() {
                return 5L;
            }

            public TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            public Class<? extends Annotation> annotationType() {
                return AccessTimeout.class;
            }
        };
    }

    private synchronized void destroySingletonInstance() {
        if (this.singletonComponentInstance != null) {
            logger.warn((Object)"Destorying of singleton instance not yet implemented");
            this.singletonComponentInstance = null;
        }
    }

    @Override
    public Object invoke(Serializable sessionId, Map<String, Object> contextData, Class<?> invokedBusinessInterface, Method beanMethod, Object[] args) throws Exception {
        if (sessionId != null) {
            throw new IllegalArgumentException("Singleton " + (Object)((Object)this) + " does not support sessions");
        }
        if (invokedBusinessInterface != null) {
            throw new UnsupportedOperationException("invokedBusinessInterface != null");
        }
        InterceptorContext context = new InterceptorContext();
        context.putPrivateData(Component.class, (Object)this);
        context.setContextData(contextData);
        context.setMethod(beanMethod);
        context.setParameters(args);
        throw new RuntimeException("invoke() not yet implemented");
    }
}

