/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulBMTInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceDestroyInterceptorFactory;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.component.stateful.StatefulComponentSessionIdGeneratingInterceptorFactory;
import org.jboss.as.ejb3.component.stateful.StatefulRemoveInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class StatefulComponentDescription
extends SessionBeanComponentDescription {
    private static final Logger logger = Logger.getLogger(StatefulComponentDescription.class);
    private Set<StatefulRemoveMethod> removeMethods = new HashSet<StatefulRemoveMethod>();

    public StatefulComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName);
    }

    public ComponentConfiguration createConfiguration(EEModuleConfiguration moduleConfiguration) {
        ComponentConfiguration statefulComponentConfiguration = new ComponentConfiguration((ComponentDescription)this, moduleConfiguration.getClassConfiguration(this.getComponentClassName()));
        statefulComponentConfiguration.setComponentCreateServiceFactory((ComponentCreateServiceFactory)new StatefulComponentCreateServiceFactory());
        return statefulComponentConfiguration;
    }

    @Override
    public boolean allowsConcurrentAccess() {
        return true;
    }

    @Override
    public SessionBeanComponentDescription.SessionBeanType getSessionBeanType() {
        return SessionBeanComponentDescription.SessionBeanType.STATEFUL;
    }

    @Override
    protected void setupViewInterceptors(ViewDescription view) {
        super.setupViewInterceptors(view);
        this.addRemoveMethodInterceptor(view);
        this.addStatefulInstanceAssociatingInterceptor(view);
        this.addTransactionManagementInterceptor(view);
    }

    public void addRemoveMethod(MethodIdentifier removeMethod, boolean retainIfException) {
        if (removeMethod == null) {
            throw new IllegalArgumentException("@Remove method identifier cannot be null");
        }
        this.removeMethods.add(new StatefulRemoveMethod(removeMethod, retainIfException));
    }

    public Set<StatefulRemoveMethod> getRemoveMethods() {
        return Collections.unmodifiableSet(this.removeMethods);
    }

    private void addStatefulInstanceAssociatingInterceptor(ViewDescription view) {
        final Object sessionIdContextKey = new Object();
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
                StatefulComponentSessionIdGeneratingInterceptorFactory sessionIdGeneratingInterceptorFactory = new StatefulComponentSessionIdGeneratingInterceptorFactory(sessionIdContextKey);
                viewConfiguration.getViewPostConstructInterceptors().addFirst(sessionIdGeneratingInterceptorFactory);
                viewConfiguration.getViewPreDestroyInterceptors().addFirst(new StatefulComponentInstanceDestroyInterceptorFactory(sessionIdContextKey));
            }
        });
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptorToFront((InterceptorFactory)new StatefulComponentInstanceInterceptorFactory(sessionIdContextKey));
            }
        });
    }

    private void addRemoveMethodInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                StatefulComponentDescription statefulComponentDescription = (StatefulComponentDescription)componentConfiguration.getComponentDescription();
                Set<StatefulRemoveMethod> removeMethods = statefulComponentDescription.getRemoveMethods();
                if (removeMethods.isEmpty()) {
                    return;
                }
                block0: for (Method viewMethod : configuration.getProxyFactory().getCachedMethods()) {
                    MethodIdentifier viewMethodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)viewMethod);
                    for (StatefulRemoveMethod removeMethod : removeMethods) {
                        if (!removeMethod.methodIdentifier.equals(viewMethodIdentifier)) continue;
                        Deque methodInterceptors = configuration.getViewInterceptorDeque(viewMethod);
                        methodInterceptors.addFirst(new ImmediateInterceptorFactory((Interceptor)new StatefulRemoveInterceptor(removeMethod.retainIfException)));
                        continue block0;
                    }
                }
            }
        });
    }

    private void addTransactionManagementInterceptor(ViewDescription view) {
        if (TransactionManagementType.CONTAINER.equals((Object)this.getTransactionManagementType())) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    logger.warn((Object)"Interceptors at ComponentInstance level aren't supported yet - SessionSynchronization semantics for Stateful beans with CMT won't work!");
                }
            });
        } else {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    ComponentInterceptorFactory bmtComponentInterceptorFactory = new ComponentInterceptorFactory(){

                        protected Interceptor create(Component component, InterceptorFactoryContext context) {
                            if (!(component instanceof StatefulSessionComponent)) {
                                throw new IllegalArgumentException("Component " + component + " with component class: " + component.getComponentClass() + " isn't a stateful component");
                            }
                            return new StatefulBMTInterceptor((StatefulSessionComponent)component);
                        }
                    };
                    configuration.addViewInterceptorToFront((InterceptorFactory)bmtComponentInterceptorFactory);
                }
            });
        }
    }

    private class StatefulRemoveMethod {
        private final MethodIdentifier methodIdentifier;
        private final boolean retainIfException;

        StatefulRemoveMethod(MethodIdentifier method, boolean retainIfException) {
            if (method == null) {
                throw new IllegalArgumentException("@Remove method cannot be null");
            }
            this.methodIdentifier = method;
            this.retainIfException = retainIfException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatefulRemoveMethod that = (StatefulRemoveMethod)o;
            return this.methodIdentifier.equals(that.methodIdentifier);
        }

        public int hashCode() {
            return this.methodIdentifier.hashCode();
        }
    }
}

