/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;

public class StatefulRemoveInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(StatefulRemoveInterceptor.class);
    private final boolean retainIfException;

    public StatefulRemoveInterceptor(boolean retainIfException) {
        this.retainIfException = retainIfException;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof StatefulSessionComponent)) {
            throw new RuntimeException("Unexpected component: " + component + " in interceptor context: " + context + " Expected an instance of " + StatefulSessionComponent.class);
        }
        StatefulSessionComponent statefulComponent = (StatefulSessionComponent)component;
        Object invocationResult = null;
        try {
            invocationResult = context.proceed();
        }
        catch (Exception e) {
            if (this.isApplicationException(statefulComponent, e.getClass()) && this.retainIfException) {
                throw e;
            }
            StatefulSessionComponentInstance statefulComponentInstance = (StatefulSessionComponentInstance)((Object)context.getPrivateData(ComponentInstance.class));
            Serializable sessionId = statefulComponentInstance.getId();
            this.removeSession(statefulComponent, sessionId);
            throw e;
        }
        StatefulSessionComponentInstance statefulComponentInstance = (StatefulSessionComponentInstance)((Object)context.getPrivateData(ComponentInstance.class));
        Serializable sessionId = statefulComponentInstance.getId();
        this.removeSession(statefulComponent, sessionId);
        return invocationResult;
    }

    private void removeSession(StatefulSessionComponent statefulComponent, Serializable sessionId) {
        Transaction currentTx = null;
        try {
            currentTx = statefulComponent.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        if (currentTx != null && TxUtils.isActive((Transaction)currentTx)) {
            try {
                currentTx.registerSynchronization((Synchronization)new RemoveSynchronization(statefulComponent, sessionId));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        } else {
            statefulComponent.getCache().remove(sessionId);
        }
    }

    private boolean isApplicationException(EJBComponent ejbComponent, Class<?> exceptionClass) {
        return ejbComponent.getApplicationException(exceptionClass) != null;
    }

    private static class RemoveSynchronization
    implements Synchronization {
        private final StatefulSessionComponent statefulComponent;
        private final Serializable sessionId;

        public RemoveSynchronization(StatefulSessionComponent component, Serializable sessionId) {
            if (sessionId == null) {
                throw new IllegalArgumentException("Session id cannot be null");
            }
            if (component == null) {
                throw new IllegalArgumentException("Stateful component cannot be null");
            }
            this.sessionId = sessionId;
            this.statefulComponent = component;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.statefulComponent.getCache().remove(this.sessionId);
            }
            catch (Throwable t) {
                logger.error((Object)("Failed to remove bean: " + this.statefulComponent.getComponentName() + " with session id " + this.sessionId), t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }
    }
}

