/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;

public class EjbBeanNameInjectionSource
extends InjectionSource {
    private final String beanName;
    private final String typeName;

    public EjbBeanNameInjectionSource(String beanName, String typeName) {
        this.beanName = beanName;
        this.typeName = typeName;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        ResourceRoot deploymentRoot;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        Set componentsForViewName = applicationDescription.getComponents(this.beanName, this.typeName, (deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT)).getRoot());
        if (componentsForViewName.isEmpty()) {
            throw new DeploymentUnitProcessingException("No component found for type '" + this.typeName + "' with name " + this.beanName);
        }
        if (componentsForViewName.size() > 1) {
            throw new DeploymentUnitProcessingException("More than 1 component found for type '" + this.typeName + "' and bean name " + this.beanName);
        }
        ViewDescription description = (ViewDescription)componentsForViewName.iterator().next();
        serviceBuilder.addDependency(description.getServiceName(), ComponentView.class, (Injector)new ViewManagedReferenceFactory.Injector(injector));
    }

    public boolean equals(Object injectionSource) {
        return injectionSource instanceof EjbBeanNameInjectionSource && this.equals((EjbBeanNameInjectionSource)((Object)injectionSource));
    }

    private boolean equals(EjbBeanNameInjectionSource configuration) {
        return configuration != null && this.typeName.equals(configuration.typeName) && this.beanName.equals(configuration.beanName);
    }

    public int hashCode() {
        int result = this.beanName != null ? this.beanName.hashCode() : 0;
        result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
        return result;
    }
}

