/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.Startup;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class StartupAnnotationProcessor
extends AbstractAnnotationEJBProcessor<SingletonComponentDescription> {
    private static final Logger logger = Logger.getLogger(StartupAnnotationProcessor.class);

    @Override
    protected Class<SingletonComponentDescription> getComponentDescriptionType() {
        return SingletonComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, SingletonComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map annotationsOnBean = beanClass.annotations();
        if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
            return;
        }
        List startupAnnotations = (List)annotationsOnBean.get(DotName.createSimple((String)Startup.class.getName()));
        if (startupAnnotations == null || startupAnnotations.isEmpty()) {
            return;
        }
        if (startupAnnotations.size() > 1) {
            throw new DeploymentUnitProcessingException("More than one @Startup annotation found on bean: " + componentDescription.getEJBName());
        }
        AnnotationInstance startupAnnotation = (AnnotationInstance)startupAnnotations.get(0);
        if (!(startupAnnotation.target() instanceof ClassInfo)) {
            throw new DeploymentUnitProcessingException("@Startup can appear only on a class. Target: " + startupAnnotation.target() + " is not a class");
        }
        componentDescription.initOnStartup();
        logger.debug((Object)(componentDescription.getEJBName() + " bean has been marked for init-on-startup (a.k.a @Startup)"));
    }
}

