/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBMethodDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AccessTimeoutMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodsMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;

public class SessionBeanXmlDescriptorProcessor
extends AbstractEjbXmlDescriptorProcessor<SessionBeanMetaData> {
    private static final Logger logger = Logger.getLogger(SessionBeanXmlDescriptorProcessor.class);

    @Override
    protected Class<SessionBeanMetaData> getMetaDataType() {
        return SessionBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(SessionBeanMetaData sessionBean, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ContainerTransactionsMetaData containerTransactions;
        BusinessRemotesMetaData businessRemotes;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String applicationName = moduleDescription.getApplicationName();
        SessionType sessionType = sessionBean.getSessionType();
        if (sessionType == null) {
            throw new DeploymentUnitProcessingException("Unknown session-type for session bean: " + sessionBean.getName() + " in deployment unit: " + deploymentUnit);
        }
        String beanName = sessionBean.getName();
        String beanClassName = sessionBean.getEjbClass();
        SessionBeanComponentDescription sessionBeanDescription = null;
        switch (sessionType) {
            case Stateless: {
                sessionBeanDescription = new StatelessComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            case Stateful: {
                sessionBeanDescription = new StatefulComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            case Singleton: {
                sessionBeanDescription = new SingletonComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown session bean type: " + sessionType);
            }
        }
        sessionBeanDescription.setMappedName(sessionBean.getMappedName());
        BusinessLocalsMetaData businessLocals = sessionBean.getBusinessLocals();
        if (businessLocals != null && !businessLocals.isEmpty()) {
            sessionBeanDescription.addLocalBusinessInterfaceViews((Collection<String>)businessLocals);
        }
        if ((businessRemotes = sessionBean.getBusinessRemotes()) != null && !businessRemotes.isEmpty()) {
            sessionBeanDescription.addRemoteBusinessInterfaceViews((Collection<String>)businessRemotes);
        }
        if (sessionBean.getTransactionType() != null) {
            sessionBeanDescription.setTransactionManagementType(sessionBean.getTransactionType());
        }
        if (sessionBean.getTransactionType() != TransactionManagementType.BEAN && (containerTransactions = sessionBean.getContainerTransactions()) != null && !containerTransactions.isEmpty()) {
            for (ContainerTransactionMetaData containerTx : containerTransactions) {
                TransactionAttributeType txAttr = containerTx.getTransAttribute();
                MethodsMetaData methods = containerTx.getMethods();
                for (MethodMetaData method : methods) {
                    String methodName = method.getMethodName();
                    MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf());
                    if (methodName.equals("*")) {
                        sessionBeanDescription.setTransactionAttribute(methodIntf, txAttr);
                        continue;
                    }
                    MethodParametersMetaData methodParams = method.getMethodParams();
                    sessionBeanDescription.setTransactionAttribute(methodIntf, txAttr, methodName, this.getMethodParams(methodParams));
                }
            }
        }
        this.processInterceptors((EnterpriseBeanMetaData)sessionBean, sessionBeanDescription);
        if (sessionBean instanceof SessionBean31MetaData) {
            this.processSessionBean31((SessionBean31MetaData)sessionBean, sessionBeanDescription);
        }
        ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)sessionBeanDescription);
    }

    private void processSessionBean31(SessionBean31MetaData sessionBean31MetaData, SessionBeanComponentDescription sessionBeanComponentDescription) {
        if (sessionBean31MetaData.isNoInterfaceBean()) {
            sessionBeanComponentDescription.addNoInterfaceView();
        }
        if (sessionBean31MetaData.isSingleton() && sessionBeanComponentDescription instanceof SingletonComponentDescription) {
            this.processSingletonBean(sessionBean31MetaData, (SingletonComponentDescription)sessionBeanComponentDescription);
        }
    }

    private void processSingletonBean(SessionBean31MetaData singletonBeanMetaData, SingletonComponentDescription singletonComponentDescription) {
        ConcurrencyManagementType concurrencyManagementType;
        Boolean initOnStartup = singletonBeanMetaData.isInitOnStartup();
        if (initOnStartup != null && initOnStartup.booleanValue()) {
            singletonComponentDescription.initOnStartup();
        }
        LockType lockType = singletonBeanMetaData.getLockType();
        singletonComponentDescription.setBeanLevelLockType(lockType);
        ConcurrentMethodsMetaData concurrentMethods = singletonBeanMetaData.getConcurrentMethods();
        if (concurrentMethods != null) {
            for (ConcurrentMethodMetaData concurrentMethod : concurrentMethods) {
                LockType methodLockType = concurrentMethod.getLockType();
                EJBMethodDescription method = this.getEJBMethodDescription(concurrentMethod.getMethod());
                singletonComponentDescription.setLockType(methodLockType, method);
            }
        }
        if ((concurrencyManagementType = singletonBeanMetaData.getConcurrencyManagementType()) == ConcurrencyManagementType.BEAN) {
            singletonComponentDescription.beanManagedConcurrency();
        } else {
            singletonComponentDescription.containerManagedConcurrency();
        }
        AccessTimeoutMetaData accessTimeoutMetaData = singletonBeanMetaData.getAccessTimeout();
        if (accessTimeoutMetaData != null) {
            final long timeout = accessTimeoutMetaData.getTimeout();
            final TimeUnit unit = accessTimeoutMetaData.getUnit();
            AccessTimeout accessTimeout = new AccessTimeout(){

                public long value() {
                    return timeout;
                }

                public TimeUnit unit() {
                    return unit;
                }

                public Class<? extends Annotation> annotationType() {
                    return AccessTimeout.class;
                }
            };
            singletonComponentDescription.setBeanLevelAccessTimeout(accessTimeout);
        }
    }

    private EJBMethodDescription getEJBMethodDescription(NamedMethodMetaData namedMethodMetaData) {
        if (namedMethodMetaData == null) {
            return null;
        }
        String methodName = namedMethodMetaData.getMethodName();
        MethodParametersMetaData methodParams = namedMethodMetaData.getMethodParams();
        if (methodParams == null) {
            return new EJBMethodDescription(methodName, (String[])null);
        }
        return new EJBMethodDescription(methodName, (String[])methodParams.toArray((Object[])new String[methodParams.size()]));
    }
}

