/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ManagementDescription;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;

public class NativeManagementAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public NativeManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        String interfaceName = operation.require("interface").asString();
        int port = operation.require("port").asInt();
        String securityRealm = operation.hasDefined("security-realm") ? operation.require("security-realm").asString() : null;
        model.get("interface").set(interfaceName);
        model.get("port").set(port);
        if (securityRealm != null) {
            model.get("security-realm").set(securityRealm);
        }
        this.hostControllerInfo.setNativeManagementInterface(interfaceName);
        this.hostControllerInfo.setNativeManagementPort(port);
        this.hostControllerInfo.setNativeManagementSecurityRealm(securityRealm);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ManagementDescription.getAddNativeManagementDescription((Locale)locale);
    }
}

