/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;

@MessageBundle(projectCode="JBAS")
public interface DomainControllerMessages {
    public static final DomainControllerMessages MESSAGES = (DomainControllerMessages)Messages.getBundle(DomainControllerMessages.class);

    @Message(id=10830, value="Registration of remote hosts is not supported on slave host controllers")
    public String slaveControllerCannotAcceptOtherSlaves();

    @Message(id=10831, value="The master host controller cannot register slave host controllers as it's current running mode is '%s'")
    public String adminOnlyModeCannotAcceptSlaves(RunningMode var1);

    @Message(id=10832, value="There is already a registered host named '%s'")
    public String slaveAlreadyRegistered(String var1);

    @Message(id=10833, value="%s is missing %s: %s")
    public String requiredChildIsMissing(String var1, String var2, String var3);

    @Message(id=10834, value="%s recognizes only %s as children: %s")
    public String unrecognizedChildren(String var1, String var2, String var3);

    @Message(id=10835, value="in-series is missing groups: %s")
    public String inSeriesIsMissingGroups(String var1);

    @Message(id=10836, value="server-group expects one and only one child: %s")
    public String serverGroupExpectsSingleChild(String var1);

    @Message(id=10837, value="One of the groups does not define neither server-group nor concurrent-groups: %s")
    public String unexpectedInSeriesGroup(String var1);

    @Message(id=10838, value="Unexplained failure")
    public String unexplainedFailure();

    @Message(id=10839, value="Operation failed or was rolled back on all servers.")
    public String operationFailedOrRolledBack();

    @Message(id=10840, value="Interrupted waiting for result from server %s")
    public String interruptedAwaitingResultFromServer(ServerIdentity var1);

    @Message(id=10841, value="Exception getting result from server %s: %s")
    public String exceptionAwaitingResultFromServer(ServerIdentity var1, String var2);

    @Message(id=10842, value="Invalid rollout plan. %s is not a valid child of node %s")
    public String invalidRolloutPlan(ModelNode var1, String var2);

    @Message(id=10843, value="Invalid rollout plan. Plan operations affect server groups %s that are not reflected in the rollout plan")
    public String invalidRolloutPlan(Set<String> var1);

    @Message(id=10844, value="Invalid rollout plan. Server group %s appears more than once in the plan.")
    public String invalidRolloutPlanGroupAlreadyExists(String var1);

    @Message(id=10845, value="Invalid rollout plan. Server group %s has a %s value of %s; must be between 0 and 100.")
    public String invalidRolloutPlanRange(String var1, String var2, int var3);

    @Message(id=10846, value="Invalid rollout plan. Server group %s has a %s value of %s; cannot be less than 0.")
    public String invalidRolloutPlanLess(String var1, String var2, int var3);

    @Message(id=10847, value="Interrupted waiting for result from host %s")
    public String interruptedAwaitingResultFromHost(String var1);

    @Message(id=10848, value="Exception getting result from host %s: %s")
    public String exceptionAwaitingResultFromHost(String var1, String var2);

    @Message(id=10849, value="Operation %s for address %s can only be handled by the master Domain Controller; this host is not the master Domain Controller")
    public String masterDomainControllerOnlyOperation(String var1, PathAddress var2);

    @Message(id=10850, value="No handler for operation %s at address %s")
    public String noHandlerForOperation(String var1, PathAddress var2);

    @Message(id=10851, value="Operation targets host %s but that host is not registered")
    public OperationFailedException invalidOperationTargetHost(String var1);

    @Message(id=10852, value="Caught %s storing deployment content -- %s")
    public OperationFailedException caughtExceptionStoringDeploymentContent(String var1, Throwable var2);

    @Message(id=10853, value="Unexpected initial path key %s")
    public IllegalStateException unexpectedInitialPathKey(String var1);

    @Message(id=10854, value="Null stream at index %d")
    public String nullStream(int var1);

    @Message(id=10855, value="Invalid byte stream.")
    public String invalidByteStream();

    @Message(id=10856, value="Invalid url stream.")
    public String invalidUrlStream();

    @Message(id=10857, value="Only 1 piece of content is currently supported (AS7-431)")
    public String as7431();

    @Message(id=10858, value="No deployment content with hash %s is available in the deployment content repository.")
    public String noDeploymentContentWithHash(String var1);

    @Message(id=10859, value="A slave domain controller cannot accept deployment content uploads")
    public String slaveCannotAcceptUploads();

    @Message(id=10860, value="No deployment with name %s found")
    public String noDeploymentContentWithName(String var1);

    @Message(id=10861, value="Cannot remove deployment %s from the domain as it is still used by server groups %s")
    public String cannotRemoveDeploymentInUse(String var1, List<String> var2);

    @Message(id=10862, value="Invalid '%s' value: %d, the maximum index is %d")
    public String invalidValue(String var1, int var2, int var3);

    @Message(id=10863, value="%s is not a valid URL -- %s")
    public String invalidUrl(String var1, String var2);

    @Message(id=10864, value="Error obtaining input stream from URL %s -- %s")
    public String errorObtainingUrlStream(String var1, String var2);

    @Message(id=10865, value="Invalid content declaration")
    public String invalidContentDeclaration();

    @Message(id=10866, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=10867, value="Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.")
    public String cannotUseSameValueForParameters(String var1, String var2, String var3, String var4, String var5);

    @Message(id=10868, value="Deployment %s is already started")
    public String deploymentAlreadyStarted(String var1);

    @Message(id=10869, value="Unknown %s %s")
    public String unknown(String var1, String var2);

    @Message(id=10870, value="Unknown server group %s")
    public IllegalStateException unknownServerGroup(String var1);

    @Message(id=10871, value="Unknown server %s")
    public IllegalStateException unknownServer(ServerIdentity var1);

    @Message(id=10872, value="Invalid code %d")
    public IllegalArgumentException invalidCode(int var1);

    @Message(id=15873, value="Repository does not contain any deployment with hash %s")
    public IllegalStateException deploymentHashNotFoundInRepository(String var1);

    @Message(id=15874, value="Expected only one deployment, found %d")
    public IllegalStateException expectedOnlyOneDeployment(int var1);

    @Message(id=10875, value="No profile called: %s")
    public OperationFailedException noProfileCalled(String var1);

    @Message(id=10876, value="No deployment content with hash %s is available in the deployment content repository for deployment '%s'. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment from the xml configuraiton file and restart.")
    public String noDeploymentContentWithHashAtBoot(String var1, String var2);
}

